/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.lock;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.lock.ILockPool;

public class LockPool<ID>
implements ILockPool<ID> {
    protected final Function<ID, Lock> lockProvider;
    protected final Lock poolLock = new ReentrantLock();
    protected final Map<ID, LockHolder> lockPool = new HashMap<ID, LockHolder>();

    public LockPool() {
        this(ReentrantLock::new);
    }

    public LockPool(Supplier<Lock> lockProvider) {
        this((ID id) -> (Lock)lockProvider.get());
    }

    public LockPool(Function<ID, Lock> lockProvider) {
        this.lockProvider = lockProvider;
    }

    @Override
    public Lock getLock(ID key) {
        return new LockWrapper(key);
    }

    protected static final class LockHolder {
        protected final AtomicInteger requested = new AtomicInteger(0);
        protected final Lock lock;

        LockHolder(Lock lock) {
            this.lock = lock;
        }

        public Lock getLock() {
            return this.lock;
        }

        public void increment() {
            this.requested.incrementAndGet();
        }

        public boolean decrement() {
            return 0 == this.requested.decrementAndGet();
        }
    }

    private class LockWrapper
    implements Lock {
        private final ID key;

        public LockWrapper(ID key) {
            this.key = key;
        }

        @Override
        public void lock() {
            LockHolder lockHolder = this.useLockFromPool();
            lockHolder.getLock().lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            LockHolder lockHolder = this.useLockFromPool();
            lockHolder.getLock().lockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            LockHolder lockHolder = this.useLockFromPool();
            return lockHolder.getLock().tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            LockHolder lockHolder = this.useLockFromPool();
            return lockHolder.getLock().tryLock(time, unit);
        }

        @Override
        public void unlock() {
            LockHolder lockHolder = this.getLockFromPool();
            lockHolder.getLock().unlock();
            if (lockHolder.decrement()) {
                this.removeLockFromPool();
            }
        }

        @Override
        public Condition newCondition() {
            LockHolder lockHolder = this.getLockFromPool();
            return lockHolder.getLock().newCondition();
        }

        private LockHolder getLockFromPool() {
            LockPool.this.poolLock.lock();
            try {
                LockHolder lockHolder = LockPool.this.lockPool.computeIfAbsent(this.key, id -> new LockHolder(LockPool.this.lockProvider.apply(id)));
                return lockHolder;
            }
            finally {
                LockPool.this.poolLock.unlock();
            }
        }

        private LockHolder useLockFromPool() {
            LockHolder lockHolder = this.getLockFromPool();
            lockHolder.increment();
            return lockHolder;
        }

        private void removeLockFromPool() {
            LockPool.this.poolLock.lock();
            try {
                if (LockPool.this.lockPool.remove(this.key) == null) {
                    throw new IllegalStateException("Lock '" + this.key + "' was removed lately");
                }
            }
            finally {
                LockPool.this.poolLock.unlock();
            }
        }
    }
}

