/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.uri;

import java.net.URI;
import java.util.regex.Pattern;

public class URIMatcher {
    protected Pattern scheme;
    protected Pattern host;
    protected Integer port;
    protected Pattern fragment;
    protected Pattern path;

    protected URIMatcher(URIMatcher copy) {
        this.scheme = copy.scheme;
        this.host = copy.host;
        this.port = copy.port;
        this.fragment = copy.fragment;
        this.path = copy.path;
    }

    public URIMatcher() {
    }

    public String asRegEx() {
        StringBuilder sb = new StringBuilder().append(this.scheme == null ? "([^:]+)" : this.scheme).append("://").append(this.host == null ? "([^/:])" : this.host).append(this.port == null ? "(:[0-9]+)?" : ":" + this.port).append(this.path == null ? "([^#]*)" : this.path).append(this.fragment == null ? "(#(.*))?" : "#" + this.fragment);
        return sb.toString();
    }

    public String toString() {
        return this.asRegEx();
    }

    public URIMatcher setScheme(String scheme) {
        this.scheme = Pattern.compile(scheme);
        return this;
    }

    public URIMatcher setHost(String host) {
        this.host = Pattern.compile(host);
        return this;
    }

    public URIMatcher setPort(Integer port) {
        this.port = port;
        return this;
    }

    public URIMatcher setFragment(String fragment) {
        this.fragment = Pattern.compile(fragment);
        return this;
    }

    public URIMatcher setPath(String path) {
        this.path = Pattern.compile(path);
        return this;
    }

    public boolean matches(URI uri) {
        if (this.scheme != null && !this.scheme.matcher(uri.getScheme()).matches()) {
            return false;
        }
        if (this.host != null && !this.host.matcher(uri.getHost()).matches()) {
            return false;
        }
        if (this.port != null && uri.getPort() != this.port.intValue()) {
            return false;
        }
        if (this.path != null && !this.path.matcher(uri.getPath()).matches()) {
            return false;
        }
        return this.fragment == null || this.fragment.matcher(uri.getFragment()).matches();
    }
}

