/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.uri;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xenei.uri.URIMatcher;

public class PatternReplacer
extends URIMatcher {
    private String pattern;

    public PatternReplacer(String pattern) {
        this.pattern = pattern;
    }

    public PatternReplacer(String pattern, URIMatcher copy) {
        super(copy);
        this.pattern = pattern;
    }

    @Override
    public PatternReplacer setScheme(String scheme) {
        super.setScheme(scheme);
        return this;
    }

    @Override
    public PatternReplacer setHost(String host) {
        super.setHost(host);
        return this;
    }

    @Override
    public PatternReplacer setPort(Integer port) {
        super.setPort(port);
        return this;
    }

    @Override
    public PatternReplacer setFragment(String fragment) {
        super.setFragment(fragment);
        return this;
    }

    @Override
    public PatternReplacer setPath(String path) {
        super.setPath(path);
        return this;
    }

    public String populate(URI uri) {
        if (!this.matches(uri)) {
            throw new IllegalArgumentException("URI does not match regular expression");
        }
        String retval = this.pattern;
        while (retval.contains("{scheme")) {
            retval = this.subEdit(retval, "{scheme", uri.getScheme(), this.getScheme());
        }
        while (retval.contains("{host")) {
            retval = this.subEdit(retval, "{host", uri.getHost(), this.getHost());
        }
        while (retval.contains("{port}")) {
            if (uri.getPort() == URIMatcher.NO_PORT.intValue()) {
                retval = retval.replace("{port}", "");
                continue;
            }
            retval = retval.replace("{port}", Integer.toString(uri.getPort()));
        }
        while (retval.contains("{path")) {
            retval = this.subEdit(retval, "{path", uri.getPath(), this.getPath());
        }
        while (retval.contains("{fragment")) {
            retval = this.subEdit(retval, "{fragment", uri.getFragment(), this.getFragment());
        }
        while (retval.contains("{uri}")) {
            retval = retval.replace("{uri}", uri.toString());
        }
        return retval;
    }

    private String valueOf(String value) {
        return value == null ? "" : value;
    }

    private String subEdit(String retval, String pattern, String value, Pattern p) {
        int pos = retval.indexOf(pattern) + pattern.length();
        if (retval.charAt(pos) == '}') {
            return retval.replace(pattern + "}", this.valueOf(value));
        }
        if (retval.charAt(pos) == ':') {
            int endpos = retval.indexOf(125, pos);
            String idxStr = retval.substring(pos + 1, endpos);
            int patternIdx = Integer.valueOf(idxStr);
            try {
                Matcher m = p.matcher(this.valueOf(value));
                m.find();
                if (m.groupCount() < patternIdx) {
                    throw new IllegalArgumentException(String.format("Subpattern %s does not exist in %s matching %s", patternIdx, p, this.valueOf(value)));
                }
                return retval.replace(retval.substring(retval.indexOf(pattern), endpos + 1), m.group(patternIdx));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException(String.format("Bad pattern string: %s", pattern));
    }

    @Override
    public String toString() {
        return String.format("URIEditor[ regEx=%s  pattern=%s]", super.toString(), this.pattern);
    }
}

