/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.uri;

import java.net.URI;
import java.util.regex.Pattern;

public class URIMatcher {
    public static final Integer NO_PORT = -1;
    public static final String ALPHA = "a-zA-Z";
    public static final String DIGIT = "0-9";
    public static final String SAFE = "\\$\\-_@\\.&";
    public static final String EXTRA = "\\!\\*\\\"\\'\\(\\),";
    public static final String ESCAPE = "%";
    public static final String XP = "\\|\\+";
    private static final String XALPHA = String.format("%s%s%s%s%s", "a-zA-Z", "a-zA-Z", "0-9", "\\$\\-_@\\.&", "\\!\\*\\\"\\'\\(\\),", "%");
    private static final String XPALPHA = String.format("%s%s", XALPHA, "\\|\\+");
    public static final String SCHEME_REGEX = String.format("(([%s][%s]*):)?", "a-zA-Z", XALPHA);
    public static final String HOST_REGEX = String.format("(//([%s][%s]*))?", "a-zA-Z", XALPHA);
    public static final String PORT_REGEX = "(:([0-9]+))?";
    public static final String PATH_REGEX = String.format("(/?[%s]+(/[%s]*))?", XPALPHA, XPALPHA);
    public static final String FRAGMENT_REGEX = String.format("(#([%s]+))?", XALPHA);
    private Pattern scheme;
    private Pattern host;
    private Integer port;
    private Pattern fragment;
    private Pattern path;

    protected URIMatcher(URIMatcher copy) {
        this.scheme = copy.scheme;
        this.host = copy.host;
        this.port = copy.port;
        this.fragment = copy.fragment;
        this.path = copy.path;
    }

    public URIMatcher() {
    }

    private String pattern(Pattern patt, String dflt, String fmt) {
        return this.pattern(patt, dflt, fmt, "");
    }

    private String pattern(Pattern patt, String dflt, String fmt, String emptyVal) {
        if (patt == null) {
            return dflt;
        }
        if (patt.pattern().length() != 0) {
            return String.format(fmt, patt.pattern());
        }
        return emptyVal;
    }

    public String asRegEx() {
        StringBuilder sb = new StringBuilder().append("^").append(this.pattern(this.scheme, SCHEME_REGEX, "(%s):")).append(this.pattern(this.host, HOST_REGEX, "//(%s)"));
        if (this.host == null || this.host.pattern().length() > 0) {
            sb.append(this.port == null ? PORT_REGEX : (this.port < 0 ? "" : ":" + this.port));
        }
        if (this.path != null && this.path.pattern().startsWith("/")) {
            sb.append(this.pattern(this.path, PATH_REGEX, "((%s))"));
        } else {
            sb.append(this.pattern(this.path, PATH_REGEX, "(/?(%s))"));
        }
        sb.append(this.pattern(this.fragment, FRAGMENT_REGEX, "(#(%s))"));
        return sb.append("$").toString();
    }

    private int hasPresence(Pattern p) {
        return p == null || p.pattern().length() > 0 ? 1 : 0;
    }

    public int getSchemePosition() {
        return this.hasPresence(this.scheme);
    }

    public int getHostPosition() {
        int retval = this.hasPresence(this.host);
        if (retval > 0) {
            retval += this.hasPresence(this.scheme);
        }
        return retval;
    }

    private int hasPresencePort() {
        return this.port == null || this.port > NO_PORT ? this.hasPresence(this.host) : 0;
    }

    public int getPortPosition() {
        int retval = this.hasPresencePort();
        if (retval > 0) {
            retval += this.hasPresence(this.scheme);
            ++retval;
        }
        return retval;
    }

    public int getPathPosition() {
        int retval = this.hasPresence(this.path);
        if (retval > 0) {
            retval += this.hasPresence(this.scheme);
            retval += this.hasPresence(this.host);
            retval += this.hasPresencePort();
        }
        return retval;
    }

    public int getFragmentPosition() {
        int retval = this.hasPresence(this.fragment);
        if (retval > 0) {
            retval += this.hasPresence(this.scheme);
            retval += this.hasPresence(this.host);
            retval += this.hasPresencePort();
            retval += this.hasPresence(this.path);
        }
        return retval;
    }

    public String toString() {
        return this.asRegEx();
    }

    public URIMatcher setScheme(String scheme) {
        this.scheme = scheme == null ? null : Pattern.compile(scheme);
        return this;
    }

    protected Pattern getScheme() {
        return this.scheme;
    }

    public URIMatcher setHost(String host) {
        this.host = host == null ? null : Pattern.compile(host);
        return this;
    }

    protected Pattern getHost() {
        return this.host;
    }

    public URIMatcher setPort(Integer port) {
        this.port = port == null ? null : Integer.valueOf(port <= NO_PORT ? -1 : port);
        return this;
    }

    protected Integer getPort() {
        return this.port;
    }

    public URIMatcher setFragment(String fragment) {
        this.fragment = fragment == null ? null : Pattern.compile(fragment);
        return this;
    }

    protected Pattern getFragment() {
        return this.fragment;
    }

    public URIMatcher setPath(String path) {
        this.path = path == null ? null : Pattern.compile(path);
        return this;
    }

    protected Pattern getPath() {
        return this.path;
    }

    private String value(String s) {
        return s == null ? "" : s;
    }

    public boolean matches(URI uri) {
        if (this.scheme != null && !this.scheme.matcher(this.value(uri.getScheme())).matches()) {
            return false;
        }
        if (this.host != null && !this.host.matcher(this.value(uri.getHost())).matches()) {
            return false;
        }
        if (this.port != null && uri.getPort() != this.port.intValue()) {
            return false;
        }
        if (this.path != null && !this.path.matcher(this.value(uri.getPath())).matches()) {
            return false;
        }
        return this.fragment == null || this.fragment.matcher(this.value(uri.getFragment())).matches();
    }
}

