/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.AndClassFilter;
import org.xenei.classpathutils.filter.NotClassFilter;
import org.xenei.classpathutils.filter.PrefixClassFilter;
import org.xenei.classpathutils.filter.RegexClassFilter;
import org.xenei.classpathutils.filter.SuffixClassFilter;

public class ClassPathUtils {
    private static final Log LOG = LogFactory.getLog(ClassPathUtils.class);
    private static PrintStream os;

    public static void doLog(Object ... args) {
        if (os != null) {
            if (args.length == 1) {
                os.println(args[0].toString());
            } else {
                os.println(String.format(args[0].toString(), Arrays.copyOfRange(args, 1, args.length)));
            }
        }
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Set<String> findClasses(String directory, String packageName) throws IOException {
        return ClassPathUtils.findClasses(directory, packageName, new PrefixClassFilter(packageName));
    }

    public static Set<String> findClasses(String directory, String packageName, ClassPathFilter filter) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        ClassPathFilter myFilter = new AndClassFilter(new SuffixClassFilter(".class"), new NotClassFilter(new PrefixClassFilter("META")), new NotClassFilter(new RegexClassFilter(".+\\$[0-9]+[\\.\\$].*")), new PrefixClassFilter(packageName.replace("/", ".")), filter).optimize();
        if (LOG.isDebugEnabled() || os != null) {
            String s = String.format("finding classes pkg: %s filter: %s ", packageName, myFilter);
            LOG.debug((Object)s);
            ClassPathUtils.doLog(s);
        }
        if (directory.contains("!") || directory.endsWith(".jar")) {
            ClassPathUtils.handleJar(classes, directory, myFilter);
        } else {
            String dirStr = directory.startsWith("file:") ? directory.substring("file:".length()) : directory;
            ClassPathUtils.scanDir(classes, packageName, new File(dirStr), myFilter);
        }
        HashSet<String> retval = new HashSet<String>();
        for (String s : classes) {
            retval.add(s.substring(0, s.length() - ".class".length()));
        }
        return retval;
    }

    public static Collection<Class<?>> getClasses(String packageName) {
        return ClassPathUtils.getClasses(packageName, new PrefixClassFilter(packageName));
    }

    public static Collection<Class<?>> getClasses(String packageName, ClassPathFilter filter) {
        ClassLoader classLoader = ClassPathUtils.getClassLoader();
        if (classLoader == null) {
            LOG.error((Object)"Class loader may not be null.  No class loader for current thread");
            return Collections.emptyList();
        }
        return ClassPathUtils.getClasses(classLoader, packageName, filter);
    }

    public static Collection<Class<?>> getClasses(ClassLoader classLoader, String packageName) {
        return ClassPathUtils.getClasses(classLoader, packageName, new PrefixClassFilter(packageName));
    }

    public static Collection<Class<?>> getClasses(ClassLoader classLoader, String packageName, ClassPathFilter filter) {
        if (classLoader == null) {
            LOG.error((Object)"Class loader may not be null.");
            return Collections.emptyList();
        }
        if (packageName == null) {
            LOG.error((Object)"Package name may not be null.");
            return Collections.emptyList();
        }
        Set<URL> resources = ClassPathUtils.getAllResources(classLoader);
        HashSet classes = new HashSet();
        HashSet<String> directories = new HashSet<String>();
        for (URL resource : resources) {
            if (LOG.isInfoEnabled() || os != null) {
                String s = String.format("getting classes processing: %s ", resource);
                LOG.debug((Object)s);
                ClassPathUtils.doLog(s);
            }
            String dir = resource.getPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Processing dir %s", dir));
            }
            if (directories.contains(dir)) continue;
            directories.add(dir);
            try {
                for (String clazz : ClassPathUtils.findClasses(dir, packageName, filter)) {
                    String err;
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)String.format("Adding class %s", clazz));
                        }
                        classes.add(Class.forName(clazz, false, classLoader));
                    }
                    catch (ClassNotFoundException e) {
                        err = String.format("Unable to get class %s due to %s", clazz, e.toString());
                        ClassPathUtils.doLog(err);
                        LOG.warn((Object)err);
                    }
                    catch (NoClassDefFoundError e) {
                        err = String.format("Unable to get class %s due to %s", clazz, e.toString());
                        ClassPathUtils.doLog(err);
                        LOG.warn((Object)err);
                    }
                }
            }
            catch (IOException e) {
                ClassPathUtils.doLog(e.toString());
                LOG.warn((Object)e.toString());
            }
        }
        return classes;
    }

    public static Set<Class<?>> filterClasses(Collection<Class<?>> classes, ClassPathFilter filter) {
        HashSet retval = new HashSet();
        for (Class<?> clazz : classes) {
            if (!filter.accept(clazz)) continue;
            retval.add(clazz);
        }
        return retval;
    }

    public static Set<String> filterClassNames(Collection<String> classNames, ClassPathFilter filter) {
        HashSet<String> retval = new HashSet<String>();
        for (String className : classNames) {
            if (!filter.accept(className)) continue;
            retval.add(className);
        }
        return retval;
    }

    public static String[] getClassPathElements() {
        String splitter = String.format("\\%s", System.getProperty("path.separator"));
        String[] classPath = System.getProperty("java.class.path").split(splitter);
        return classPath;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        LinkedHashSet implClasses = new LinkedHashSet();
        ClassPathUtils.getAllInterfaces(implClasses, clazz);
        return implClasses;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz, ClassPathFilter filter) {
        return ClassPathUtils.filterClasses(ClassPathUtils.getAllInterfaces(clazz), filter);
    }

    public static void getAllInterfaces(Set<Class<?>> set, Class<?> c) {
        if (c == null || c == Object.class) {
            return;
        }
        for (Class<?> i : c.getClasses()) {
            if (!i.isInterface() || set.contains(i)) continue;
            set.add(i);
            ClassPathUtils.getAllInterfaces(set, i);
        }
        for (Class<?> i : c.getInterfaces()) {
            if (set.contains(i)) continue;
            set.add(i);
            ClassPathUtils.getAllInterfaces(set, i);
        }
        ClassPathUtils.getAllInterfaces(set, c.getSuperclass());
    }

    public static Set<String> findResources(String directory, String packageName) throws IOException {
        return ClassPathUtils.findResources(directory, packageName, new PrefixClassFilter(packageName));
    }

    public static Set<String> findResources(String directory, String packageName, ClassPathFilter filter) throws IOException {
        ClassPathFilter myFilter = filter.optimize();
        if (LOG.isInfoEnabled() || os != null) {
            String s = String.format("finding resources pkg: %s filter: %s ", packageName, myFilter);
            LOG.info((Object)s);
            ClassPathUtils.doLog(s);
        }
        HashSet<String> classes = new HashSet<String>();
        if (directory.contains("!") || directory.endsWith(".jar")) {
            ClassPathUtils.handleJar(classes, directory, myFilter);
        } else {
            String dirStr = directory.startsWith("file:") ? directory.substring("file:".length()) : directory;
            ClassPathUtils.scanDir(classes, packageName, new File(dirStr), myFilter);
        }
        return classes;
    }

    public static Collection<URL> getResources(String packageName) {
        return ClassPathUtils.getResources(packageName, new PrefixClassFilter(packageName));
    }

    public static Collection<URL> getResources(String packageName, ClassPathFilter filter) {
        ClassLoader classLoader = ClassPathUtils.getClassLoader();
        if (classLoader == null) {
            LOG.error((Object)"Class loader may not be null.  No class loader for current thread");
            return Collections.emptyList();
        }
        return ClassPathUtils.getResources(classLoader, packageName, filter);
    }

    public static Collection<URL> getResources(ClassLoader classLoader, String packageName) {
        return ClassPathUtils.getResources(classLoader, packageName, new PrefixClassFilter(packageName));
    }

    private static Set<URL> getAllResources(ClassLoader classLoader) {
        LinkedHashSet<URL> lst = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> e = classLoader.getResources("");
            while (e.hasMoreElements()) {
                lst.add(e.nextElement());
            }
        }
        catch (IOException e1) {
            LOG.error((Object)e1.toString());
        }
        ClassPathUtils.doLog("Found resources: %s", lst);
        return lst;
    }

    public static Collection<URL> getResources(ClassLoader classLoader, String packageName, ClassPathFilter filter) {
        if (classLoader == null) {
            LOG.error((Object)"Class loader may not be null.");
            return Collections.emptyList();
        }
        if (packageName == null) {
            LOG.error((Object)"Package name may not be null.");
            return Collections.emptyList();
        }
        if (LOG.isInfoEnabled() || os != null) {
            String s = String.format("getting resources pkg: %s filter: %s ", packageName, filter);
            LOG.info((Object)s);
            if (os != null) {
                os.println(s);
            }
        }
        Set<URL> resources = ClassPathUtils.getAllResources(classLoader);
        HashSet<URL> classes = new HashSet<URL>();
        HashSet<String> directories = new HashSet<String>();
        for (URL resource : resources) {
            String dir = resource.getPath();
            if (directories.contains(dir)) continue;
            directories.add(dir);
            try {
                for (String clazz : ClassPathUtils.findResources(dir, packageName, filter)) {
                    URL url;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Adding class %s", clazz));
                    }
                    if ((url = classLoader.getResource(clazz)) != null) {
                        classes.add(url);
                        continue;
                    }
                    LOG.warn((Object)String.format("Unable to locate: %s", clazz));
                }
            }
            catch (IOException e) {
                LOG.warn((Object)e.toString());
            }
        }
        return classes;
    }

    private static void handleDir(Set<String> classes, String packageName, File dir, ClassPathFilter cFilter) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            for (File file : dir.listFiles((FileFilter)new NotFileFilter(DirectoryFileFilter.DIRECTORY))) {
                ClassPathUtils.handleDir(classes, packageName, file, cFilter);
            }
            for (File file : dir.listFiles((FileFilter)new AndFileFilter(DirectoryFileFilter.DIRECTORY, (IOFileFilter)new NotFileFilter((IOFileFilter)new PrefixFileFilter("."))))) {
                String newPkgName = String.format("%s%s%s", packageName, packageName.length() > 0 ? "." : "", file.getName());
                ClassPathUtils.handleDir(classes, newPkgName, file, cFilter);
            }
        } else {
            String className = String.format("%s%s%s", packageName, packageName.length() > 0 ? "." : "", ClassPathUtils.modifyFileName(dir.getName()));
            if (cFilter.accept(className)) {
                classes.add(className);
            }
        }
    }

    private static void scanDir(Set<String> classes, String packageName, File dir, ClassPathFilter cFilter) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            if (dir.getPath().endsWith(packageName.replace('.', '/'))) {
                ClassPathUtils.handleDir(classes, packageName, dir, cFilter);
            } else {
                for (File file : dir.listFiles((FileFilter)new AndFileFilter(DirectoryFileFilter.DIRECTORY, (IOFileFilter)new NotFileFilter((IOFileFilter)new PrefixFileFilter("."))))) {
                    ClassPathUtils.scanDir(classes, packageName, file, cFilter);
                }
            }
        }
    }

    private static String modifyFileName(String fileName) {
        return fileName.replace('/', '.');
    }

    private static void handleJar(Set<String> classes, String directory, ClassPathFilter filter) throws IOException {
        String[] split = directory.split("!");
        URL jar = null;
        try {
            jar = new URL(split[0]);
        }
        catch (MalformedURLException e) {
            jar = new File(split[0]).toURI().toURL();
        }
        String prefix = split.length > 1 && split[1].length() > 0 ? split[1].substring(1) : "";
        ZipInputStream zip = new ZipInputStream(jar.openStream());
        ClassPathFilter myFilter = new AndClassFilter(new PrefixClassFilter(prefix), filter).optimize();
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            String className = ClassPathUtils.modifyFileName(entry.getName());
            if (!myFilter.accept(className)) continue;
            classes.add(className);
        }
    }

    static {
        String s = System.getProperty("ClassPathUtils_DEBUG");
        if (s != null) {
            os = System.out;
        }
    }
}

