/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter._AbstractBaseFilter;
import org.xenei.classpathutils.filter.types.ClassFilterType;

public class HasAnnotationClassFilter
extends _AbstractBaseFilter
implements ClassFilterType {
    private static final Log LOG = LogFactory.getLog(HasAnnotationClassFilter.class);
    private Class<? extends Annotation> annotation;

    public HasAnnotationClassFilter(Class<? extends Annotation> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation may not be null");
        }
        this.annotation = annotation;
    }

    @Override
    public String funcName() {
        return "HasAnnotation";
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return null != clazz.getAnnotation(this.annotation);
    }

    @Override
    public boolean accept(String className) {
        try {
            return this.accept(this.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError x) {
            return false;
        }
    }

    @Override
    public boolean accept(URL url) {
        return false;
    }

    @Override
    public String[] args() {
        return new String[]{this.annotation.getName()};
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    @Override
    public ClassPathFilter optimize() {
        return this;
    }
}

