/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.FalseClassFilter;
import org.xenei.classpathutils.filter.TrueClassFilter;
import org.xenei.classpathutils.filter._AbstractConditionalFilter;

public class OrClassFilter
extends _AbstractConditionalFilter
implements Serializable {
    private static final long serialVersionUID = 4219706007335645398L;

    public OrClassFilter(Collection<ClassPathFilter> filters) {
        super(filters);
    }

    public OrClassFilter(ClassPathFilter ... filters) {
        super(filters);
    }

    @Override
    public String funcName() {
        return "Or";
    }

    @Override
    public boolean accept(URL url) {
        List<ClassPathFilter> filters = this.getFilters();
        if (filters.isEmpty()) {
            return false;
        }
        for (ClassPathFilter filter : filters) {
            if (!filter.accept(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(String className) {
        List<ClassPathFilter> filters = this.getFilters();
        if (filters.isEmpty()) {
            return false;
        }
        for (ClassPathFilter filter : filters) {
            if (!filter.accept(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(Class<?> clazz) {
        List<ClassPathFilter> filters = this.getFilters();
        if (filters.isEmpty()) {
            return false;
        }
        for (ClassPathFilter filter : filters) {
            if (!filter.accept(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClassPathFilter optimize() {
        LinkedHashSet<ClassPathFilter> filters = new LinkedHashSet<ClassPathFilter>(this.getFilters());
        boolean changed = false;
        for (ClassPathFilter f : this.getFilters()) {
            ClassPathFilter f2 = f.optimize();
            if (f2 == TrueClassFilter.TRUE) {
                return TrueClassFilter.TRUE;
            }
            if (f2 == FalseClassFilter.FALSE) {
                changed = true;
                filters.remove(f);
                continue;
            }
            if (f.equals(f2)) continue;
            changed = true;
            filters.remove(f);
            filters.add(f2);
        }
        if (filters.size() == 0) {
            return FalseClassFilter.FALSE;
        }
        if (filters.size() == 1) {
            return (ClassPathFilter)filters.iterator().next();
        }
        ArrayList<ClassPathFilter> filterOrder = new ArrayList<ClassPathFilter>(filters);
        filterOrder.sort(EXECUTION_ORDER);
        if (!changed) {
            Iterator<ClassPathFilter> iter1 = this.getFilters().iterator();
            Iterator iter2 = filterOrder.iterator();
            while (iter1.hasNext()) {
                if (iter1.next().equals(iter2.next())) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            return new OrClassFilter(filterOrder);
        }
        return this;
    }
}

