/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.Case;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.FalseClassFilter;
import org.xenei.classpathutils.filter.TrueClassFilter;
import org.xenei.classpathutils.filter._AbstractStringFilter;

public class PrefixClassFilter
extends _AbstractStringFilter
implements Serializable {
    private static final Log LOG = LogFactory.getLog(PrefixClassFilter.class);
    private static final long serialVersionUID = -5764899732969345726L;

    public PrefixClassFilter(String prefix) {
        super(prefix);
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    public PrefixClassFilter(Case caseSensitivity, String prefix) {
        super(caseSensitivity, prefix);
    }

    public PrefixClassFilter(String ... prefixes) {
        super(prefixes);
    }

    public PrefixClassFilter(Case caseSensitivity, String ... prefixes) {
        super(caseSensitivity, prefixes);
    }

    public PrefixClassFilter(List<String> prefixes) {
        super(prefixes);
    }

    public PrefixClassFilter(Case caseSensitivity, Collection<String> prefixes) {
        super(caseSensitivity, prefixes);
    }

    @Override
    public boolean accept(String className) {
        for (String prefix : this.getStrings()) {
            if (!this.caseSensitivity.checkStartsWith(className, prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClassPathFilter optimize() {
        LinkedHashSet<String> set = new LinkedHashSet<String>(this.getStrings());
        if (set.size() == 0) {
            return FalseClassFilter.FALSE;
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (((String)iter.next()).length() != 0) continue;
            return TrueClassFilter.TRUE;
        }
        if (set.size() < this.getStrings().size()) {
            return new PrefixClassFilter(this.caseSensitivity, set);
        }
        return this;
    }
}

