/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.Case;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.OrClassFilter;
import org.xenei.classpathutils.filter.RegexClassFilter;
import org.xenei.classpathutils.filter._AbstractBaseFilter;
import org.xenei.classpathutils.filter.types.StringFilterType;

public class WildcardClassFilter
extends _AbstractBaseFilter
implements Serializable,
StringFilterType {
    private static final Log LOG = LogFactory.getLog(WildcardClassFilter.class);
    private static final long serialVersionUID = 4689016340648211889L;
    private final List<String> wildcards = new ArrayList<String>();
    private final Case caseSensitivity;
    private ClassPathFilter wrapped;

    public WildcardClassFilter(String wildcard) {
        this((Case)null, wildcard);
    }

    public WildcardClassFilter(Case caseSensitivity, String wildcard) {
        this.caseSensitivity = caseSensitivity == null ? Case.SENSITIVE : caseSensitivity;
        this.addWildcard(wildcard);
    }

    public WildcardClassFilter(String ... wildcards) {
        this((Case)null, wildcards);
    }

    public WildcardClassFilter(Case caseSensitivity, String ... wildcards) {
        if (wildcards.length == 0) {
            throw new IllegalArgumentException("The wildcard array may not be empty");
        }
        this.caseSensitivity = caseSensitivity == null ? Case.SENSITIVE : caseSensitivity;
        this.addWildCards(wildcards);
    }

    public WildcardClassFilter(Collection<String> wildcards) {
        this(null, wildcards);
    }

    public WildcardClassFilter(Case caseSensitivity, Collection<String> wildcards) {
        if (wildcards == null || wildcards.size() == 0) {
            throw new IllegalArgumentException("The wildcard list may not be empty");
        }
        this.caseSensitivity = caseSensitivity == null ? Case.SENSITIVE : caseSensitivity;
        this.addWildCards(wildcards);
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    public void addWildCards(Collection<String> wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        for (String s : wildcards) {
            this.addWildcard(s);
        }
    }

    public void addWildCards(String ... wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        for (String s : wildcards) {
            this.addWildcard(s);
        }
    }

    public void addWildcard(String wildcard) {
        if (wildcard == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards.add(wildcard);
        RegexClassFilter filter = new RegexClassFilter(this.caseSensitivity, WildcardClassFilter.makeRegex(wildcard));
        if (this.wrapped == null) {
            this.wrapped = filter;
        } else if (this.wrapped instanceof RegexClassFilter) {
            this.wrapped = new OrClassFilter(this.wrapped, filter);
        } else {
            ((OrClassFilter)this.wrapped).addFilter(filter);
        }
    }

    @Override
    public String toString() {
        return ClassPathFilter.Util.toString(this);
    }

    private static StringBuilder escapeString(StringBuilder sb, String s) {
        if (s != null && s.length() != 0) {
            sb.append(Pattern.quote(s));
        }
        return sb;
    }

    private static void parseWildAsterisk(StringBuilder sb, String s) {
        String[] blocks = s.split("\\*");
        Iterator<String> iter = Arrays.asList(blocks).iterator();
        if (iter.hasNext()) {
            WildcardClassFilter.escapeString(sb, iter.next());
            while (iter.hasNext()) {
                sb = WildcardClassFilter.escapeString(sb.append(".*"), iter.next());
            }
            if (s.endsWith("*")) {
                sb.append(".*");
            }
        } else if (s.equals("*")) {
            sb.append(".*");
        }
    }

    private static StringBuilder parseWildQuestion(StringBuilder sb, String s) {
        String[] blocks = s.split("\\?");
        Iterator<String> iter = Arrays.asList(blocks).iterator();
        if (iter.hasNext()) {
            WildcardClassFilter.parseWildAsterisk(sb, iter.next());
            while (iter.hasNext()) {
                sb.append(".");
                WildcardClassFilter.parseWildAsterisk(sb, iter.next());
            }
            if (s.endsWith("?")) {
                sb.append(".");
            }
        } else if (s.equals("?")) {
            sb.append(".");
        }
        return sb;
    }

    public static String makeRegex(String wildcard) {
        if (wildcard == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        return WildcardClassFilter.parseWildQuestion(new StringBuilder("^"), wildcard).append("$").toString();
    }

    @Override
    public boolean accept(URL url) {
        return this.wrapped.accept(url);
    }

    @Override
    public boolean accept(String className) {
        return this.wrapped.accept(className);
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return this.accept(clazz.getName());
    }

    @Override
    public String[] args() {
        String[] retval = new String[this.wildcards.size() + 1];
        retval[0] = this.caseSensitivity.toString();
        for (int i = 0; i < this.wildcards.size(); ++i) {
            retval[i + 1] = this.wildcards.get(i);
        }
        return retval;
    }

    @Override
    public ClassPathFilter optimize() {
        this.wrapped = this.wrapped.optimize();
        return this;
    }
}

