/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.xenei.junit.contract.filter.ClassFilter;
import org.xenei.junit.contract.filter.parser.Parser;
import org.xenei.junit.contract.tooling.InterfaceReport;

public class CmdLine {
    public static void main(String[] args) throws ParseException, MalformedURLException {
        HelpFormatter formatter;
        CommandLine commands = new BasicParser().parse(CmdLine.getOptions(), args);
        if (commands.hasOption("h")) {
            formatter = new HelpFormatter();
            formatter.printHelp("CmdLine", CmdLine.getOptions());
            System.exit(0);
        }
        if (!commands.hasOption("p")) {
            System.out.println("At least on package must be specified");
            formatter = new HelpFormatter();
            formatter.printHelp("CmdLine", CmdLine.getOptions());
            System.exit(1);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (commands.hasOption("d")) {
            String[] dirs = commands.getOptionValues("d");
            URL[] urls = null;
            urls = new URL[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                urls[i] = new File(dirs[i]).toURI().toURL();
            }
            classLoader = new URLClassLoader(urls, classLoader);
        }
        ClassFilter filter = null;
        if (commands.hasOption("c")) {
            filter = new Parser().parse(commands.getOptionValue("c"));
        }
        InterfaceReport ifReport = new InterfaceReport(commands.getOptionValues("p"), filter, classLoader);
        if (commands.hasOption("u")) {
            System.out.println("Untested Interfaces");
            ClassFilter f = new Parser().parse(commands.getOptionValue("u"));
            for (Class c : f.filter((Collection)ifReport.getUntestedInterfaces())) {
                System.out.println(c.getCanonicalName());
            }
            System.out.println("End of Report");
        }
        if (commands.hasOption("i")) {
            System.out.println("Missing contract test implementations");
            ClassFilter f = new Parser().parse(commands.getOptionValue("i"));
            for (Class c : f.filter((Collection)ifReport.getUnImplementedTests())) {
                System.out.println(c.getName());
            }
            System.out.println("End of Report");
        }
        if (commands.hasOption("e")) {
            System.out.println("Misconfigured contract test report");
            for (Throwable t : ifReport.getErrors()) {
                System.out.println(t.toString());
            }
            System.out.println("End of Report");
        }
    }

    private static Options getOptions() {
        Options retval = new Options();
        retval.addOption("h", "help", false, "Display this help page");
        retval.addOption("p", "package", true, "Package to be scanned");
        retval.addOption("d", "directory", true, "Directory to be scanned for classes");
        retval.addOption("u", "untested", true, "Filter for classes to include in the untested class report.  If not set no untested class report is generated.  Suggest: true()");
        retval.addOption("i", "implementation", false, "Filter for classes to include in the missing implementation class report.  If not set no missing implementation class report is generated.  Suggest: true()");
        retval.addOption("e", "errors", false, "Produce contract test configuration error report");
        retval.addOption("c", "classFilter", true, "A class filter function. Classes that pass the filter will be included.  Default to true() ");
        return retval;
    }
}

