/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathUtils.class);

    public static Set<String> findClasses(String directory, String packageName) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        if (directory.startsWith("file:") && directory.contains("!")) {
            String[] split = directory.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("\\$.*", "").replaceAll("\\.class", "").replace('/', '.')).startsWith(packageName)) continue;
                classes.add(className);
            }
        } else {
            File[] files;
            File dir = new File(directory);
            if (!dir.exists()) {
                return classes;
            }
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    if (file.getName().contains(".")) continue;
                    String newPkgName = String.format("%s%s%s", packageName, packageName.length() > 0 ? "." : "", file.getName());
                    classes.addAll(ClassPathUtils.findClasses(file.getAbsolutePath(), newPkgName));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
            }
        }
        return classes;
    }

    public static Collection<Class<?>> getClasses(String packageName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            LOG.error("Class loader may not be null.  No class loader for current thread");
            return Collections.emptyList();
        }
        return ClassPathUtils.getClasses(classLoader, packageName);
    }

    public static Collection<Class<?>> getClasses(ClassLoader classLoader, String packageName) {
        Enumeration<URL> resources;
        if (classLoader == null) {
            LOG.error("Class loader may not be null.");
            return Collections.emptyList();
        }
        String path = packageName == null ? "" : packageName.replace('.', '/');
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException e1) {
            LOG.error(e1.toString());
            return Collections.emptyList();
        }
        HashSet classes = new HashSet();
        if (resources.hasMoreElements()) {
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    for (String clazz : ClassPathUtils.findClasses(resource.getFile(), packageName)) {
                        try {
                            LOG.debug("Adding class {}", (Object)clazz);
                            classes.add(Class.forName(clazz, false, classLoader));
                        }
                        catch (ClassNotFoundException e) {
                            LOG.warn(e.toString());
                        }
                    }
                }
                catch (IOException e) {
                    LOG.warn(e.toString());
                }
            }
        } else {
            try {
                classes.add(Class.forName(packageName, false, classLoader));
            }
            catch (ClassNotFoundException e) {
                LOG.warn(String.format("'%s' was neither a package name nor a class name", packageName));
            }
        }
        return classes;
    }

    public static String[] getClassPathElements() {
        String splitter = String.format("\\%s", System.getProperty("path.separator"));
        String[] classPath = System.getProperty("java.class.path").split(splitter);
        return classPath;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        LinkedHashSet implClasses = new LinkedHashSet();
        ClassPathUtils.getAllInterfaces(implClasses, clazz);
        return implClasses;
    }

    public static void getAllInterfaces(Set<Class<?>> set, Class<?> c) {
        if (c == null || c == Object.class) {
            return;
        }
        for (Class<?> i : c.getClasses()) {
            if (!i.isInterface() || set.contains(i)) continue;
            set.add(i);
            ClassPathUtils.getAllInterfaces(set, i);
        }
        for (Class<?> i : c.getInterfaces()) {
            if (set.contains(i)) continue;
            set.add(i);
            ClassPathUtils.getAllInterfaces(set, i);
        }
        ClassPathUtils.getAllInterfaces(set, c.getSuperclass());
    }
}

