/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.ContractImpl;
import org.xenei.junit.contract.ContractTest;
import org.xenei.junit.contract.ContractTestRunner;
import org.xenei.junit.contract.Dynamic;
import org.xenei.junit.contract.info.ContractTestMap;
import org.xenei.junit.contract.info.DynamicSuiteInfo;
import org.xenei.junit.contract.info.DynamicTestInfo;
import org.xenei.junit.contract.info.SuiteInfo;
import org.xenei.junit.contract.info.TestInfo;
import org.xenei.junit.contract.info.TestInfoErrorRunner;

@Ignore(value="Not a real test")
public class ContractSuite
extends ParentRunner<Runner> {
    private static final Logger LOG = LoggerFactory.getLogger(ContractSuite.class);
    private final List<Runner> fRunners;

    public ContractSuite(Class<?> cls, RunnerBuilder builder) throws Throwable {
        super(cls);
        ContractTestMap contractTestMap = ContractTestMap.populateInstance();
        Object baseObj = cls.newInstance();
        List<Runner> r = baseObj instanceof Dynamic ? this.addDynamicClasses(builder, contractTestMap, (Dynamic)baseObj) : this.addAnnotatedClasses(cls, builder, contractTestMap, baseObj);
        this.fRunners = Collections.unmodifiableList(r);
    }

    private ContractImpl getContractImpl(Class<?> cls) throws InitializationError {
        ContractImpl impl = cls.getAnnotation(ContractImpl.class);
        if (impl == null) {
            throw new InitializationError("Classes annotated as @RunWith( ContractSuite ) [" + cls + "] must also be annotated with @ContractImpl");
        }
        return impl;
    }

    private List<Runner> addDynamicClasses(RunnerBuilder builder, ContractTestMap contractTestMap, Dynamic dynamic) throws InitializationError {
        Class<?> cls = dynamic.getClass();
        ArrayList<Runner> r = new ArrayList<Runner>();
        ContractImpl impl = this.getContractImpl(cls);
        if (impl == null) {
            return r;
        }
        DynamicSuiteInfo dynamicSuiteInfo = new DynamicSuiteInfo((Class<? extends Dynamic>)cls, impl);
        Collection<Class<?>> tests = dynamic.getSuiteClasses();
        if (tests == null || tests.size() == 0) {
            throw new InitializationError("Dynamic suite did not return a list of classes to execute");
        }
        for (Class<?> test : tests) {
            RunWith runwith = test.getAnnotation(RunWith.class);
            if (runwith != null && runwith.value().equals(ContractSuite.class)) {
                impl = this.getContractImpl(test);
                if (impl == null) continue;
                DynamicTestInfo parentTestInfo = new DynamicTestInfo(test, impl, dynamicSuiteInfo);
                this.addSpecifiedClasses(r, test, builder, contractTestMap, dynamic, parentTestInfo);
                continue;
            }
            try {
                r.add(builder.runnerForClass(test));
            }
            catch (Throwable t) {
                throw new InitializationError(t);
            }
        }
        return r;
    }

    private List<Runner> addAnnotatedClasses(Class<?> cls, RunnerBuilder builder, ContractTestMap contractTestMap, Object baseObj) throws InitializationError {
        ArrayList<Runner> r = new ArrayList<Runner>();
        ContractImpl impl = this.getContractImpl(cls);
        if (impl != null) {
            TestInfo testInfo = contractTestMap.getInfoByTestClass(impl.value());
            if (testInfo == null) {
                testInfo = new SuiteInfo(cls, impl);
                contractTestMap.add(testInfo);
            }
            this.addSpecifiedClasses(r, cls, builder, contractTestMap, baseObj, testInfo);
        }
        return r;
    }

    private void addSpecifiedClasses(List<Runner> r, Class<?> cls, RunnerBuilder builder, ContractTestMap contractTestMap, Object baseObj, TestInfo parentTestInfo) throws InitializationError {
        LinkedHashSet<TestInfo> testClasses = new LinkedHashSet<TestInfo>();
        BaseClassRunner bcr = new BaseClassRunner(cls);
        if (bcr.computeTestMethods().size() > 0) {
            r.add((Runner)bcr);
        }
        for (TestInfo testInfo : contractTestMap.getAnnotatedClasses(testClasses, parentTestInfo)) {
            if (testInfo.getErrors().size() > 0) {
                LOG.error("Errors during parsing " + testInfo);
                TestInfoErrorRunner runner = new TestInfoErrorRunner(cls, testInfo);
                runner.logErrors(LOG);
                r.add(runner);
                continue;
            }
            r.add((Runner)new ContractTestRunner(baseObj, parentTestInfo, testInfo));
        }
        if (r.size() == 0) {
            throw new InitializationError("No tests for " + cls);
        }
    }

    protected List<Runner> getChildren() {
        return this.fRunners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }

    private class BaseClassRunner
    extends BlockJUnit4ClassRunner {
        private List<FrameworkMethod> testMethods;

        public BaseClassRunner(Class<?> cls) throws InitializationError {
            super(cls);
            this.testMethods = null;
        }

        protected Statement withAfterClasses(Statement statement) {
            return statement;
        }

        protected Statement withBeforeClasses(Statement statement) {
            return statement;
        }

        protected void validateInstanceMethods(List<Throwable> errors) {
            this.validatePublicVoidNoArgMethods(After.class, false, errors);
            this.validatePublicVoidNoArgMethods(Before.class, false, errors);
            this.validateTestMethods(errors);
        }

        protected List<FrameworkMethod> computeTestMethods() {
            if (this.testMethods == null) {
                this.testMethods = new ArrayList<FrameworkMethod>();
                for (FrameworkMethod mthd : super.getTestClass().getAnnotatedMethods(ContractTest.class)) {
                    if (mthd.getMethod().getDeclaringClass().getAnnotation(Contract.class) != null) continue;
                    this.testMethods.add(mthd);
                }
            }
            return this.testMethods;
        }
    }
}

