/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.info;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xenei.junit.contract.ClassPathUtils;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.info.TestInfo;

public class ContractTestMap {
    private final Map<Class<?>, TestInfo> classToInfoMap = new HashMap();
    private final Map<Class<?>, Set<TestInfo>> interfaceToInfoMap = new HashMap();
    private static final Set<String> skipInterfaces;
    private static final Logger LOG;

    public static ContractTestMap populateInstance() {
        ContractTestMap retval = new ContractTestMap();
        for (Class<?> clazz : ClassPathUtils.getClasses("")) {
            if (skipInterfaces.contains(clazz.getName())) continue;
            LOG.debug("seeking contracts for {}", clazz);
            Contract c = clazz.getAnnotation(Contract.class);
            if (c == null) continue;
            LOG.debug("adding {} {}", clazz, (Object)c);
            retval.add(new TestInfo(clazz, c));
        }
        return retval;
    }

    public static ContractTestMap populateInstance(ClassLoader classLoader) {
        return ContractTestMap.populateInstance(classLoader, new String[]{""});
    }

    public static ContractTestMap populateInstance(ClassLoader classLoader, String[] packages) {
        ContractTestMap retval = new ContractTestMap();
        for (Class<?> clazz : ClassPathUtils.getClasses(classLoader, "")) {
            Contract c;
            boolean report = false;
            LOG.debug("Checking error logging for {}", clazz);
            for (String pkg : packages) {
                LOG.debug("Checking {} against {}", (Object)pkg, (Object)clazz.getPackage());
                report |= clazz.getPackage().getName().startsWith(pkg);
            }
            if (!report || (c = clazz.getAnnotation(Contract.class)) == null) continue;
            retval.add(new TestInfo(clazz, c));
        }
        return retval;
    }

    public void add(TestInfo info) {
        this.classToInfoMap.put(info.getContractTestClass(), info);
        Set<TestInfo> tiSet = this.interfaceToInfoMap.get(info.getInterfaceClass());
        if (tiSet == null) {
            tiSet = new HashSet<TestInfo>();
            this.interfaceToInfoMap.put(info.getInterfaceClass(), tiSet);
        }
        tiSet.add(info);
    }

    public TestInfo getInfoByTestClass(Class<?> testClass) {
        return this.classToInfoMap.get(testClass);
    }

    public Set<TestInfo> getInfoByInterfaceClass(Class<?> contract) {
        return this.interfaceToInfoMap.get(contract);
    }

    public Set<TestInfo> getAnnotatedClasses(TestInfo contractClassInfo) {
        return this.getAnnotatedClasses(new LinkedHashSet<TestInfo>(), contractClassInfo);
    }

    public Set<TestInfo> getAnnotatedClasses(Set<TestInfo> testClasses, TestInfo contractClassInfo) {
        Set<Class<?>> implClasses = ClassPathUtils.getAllInterfaces(contractClassInfo.getInterfaceClass());
        List<Class<?>> skipList = Arrays.asList(contractClassInfo.getSkipTests());
        for (Class<?> clazz : implClasses) {
            if (skipList.contains(clazz)) {
                LOG.info(String.format("Skipping %s for %s", clazz, contractClassInfo));
                continue;
            }
            Set<TestInfo> tiSet = this.getInfoByInterfaceClass(clazz);
            if (tiSet.isEmpty()) {
                LOG.info(String.format("Checked %s found nothing", clazz));
                continue;
            }
            testClasses.addAll(tiSet);
        }
        return testClasses;
    }

    public Collection<TestInfo> listTestInfo() {
        return this.classToInfoMap.values();
    }

    static {
        LOG = LoggerFactory.getLogger(ContractTestMap.class);
        skipInterfaces = new HashSet<String>();
        String prop = System.getProperty("contracts.skipClasses");
        if (prop != null) {
            for (String iFace : prop.split(",")) {
                skipInterfaces.add(iFace);
            }
        }
    }
}

