/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.info;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.runners.model.TestClass;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.ContractImpl;
import org.xenei.junit.contract.MethodUtils;

public class TestInfo
implements Comparable<TestInfo> {
    private final Class<?> contractTest;
    private final Class<?> interfaceUnderTest;
    private final Class<?>[] skipTests;
    private final List<Throwable> errors;
    private final int hash;
    private final Method method;

    protected TestInfo(Class<?> testSuite, ContractImpl impl, Method m) {
        this.contractTest = testSuite;
        this.interfaceUnderTest = impl.value();
        this.skipTests = impl.skip();
        this.method = m;
        this.hash = this.toString().hashCode();
        this.errors = new ArrayList<Throwable>();
    }

    protected void addError(Throwable t) {
        this.errors.add(t);
    }

    public TestInfo(Class<?> contractTest, Contract c) {
        this.contractTest = contractTest;
        this.interfaceUnderTest = c.value();
        this.skipTests = new Class[0];
        this.method = MethodUtils.findAnnotatedSetter(contractTest, Contract.Inject.class);
        this.hash = this.toString().hashCode();
        this.errors = new ArrayList<Throwable>();
        if (Modifier.isAbstract(contractTest.getModifiers())) {
            this.errors.add(new IllegalStateException("Classes annotated with @Contract (" + contractTest + ") must not be abstract"));
        }
        if (this.method == null) {
            this.errors.add(new IllegalStateException("Classes annotated with @Contract (" + contractTest + ") must include a @Contract.Inject annotation on a non-abstract declared setter method"));
        }
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public Class<?>[] getSkipTests() {
        return this.skipTests;
    }

    public String getInterfacePackageName() {
        return this.interfaceUnderTest.getPackage().getName();
    }

    public String getSimpleInterfaceName() {
        return this.interfaceUnderTest.getSimpleName();
    }

    public String getSimpleTestName() {
        return this.contractTest.getSimpleName();
    }

    public String getContractName() {
        return this.interfaceUnderTest.getCanonicalName();
    }

    public String getTestName() {
        return this.contractTest.getCanonicalName();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.contractTest.getModifiers());
    }

    public Class<?> getContractTestClass() {
        return this.contractTest;
    }

    public TestClass getJunitTestClass() {
        return new TestClass(this.contractTest);
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceUnderTest;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return String.format("[%s testing %s]", this.getSimpleTestName(), this.getSimpleInterfaceName());
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o instanceof TestInfo) {
            return this.compareTo((TestInfo)o) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(TestInfo o) {
        return this.toString().compareTo(o.toString());
    }
}

