/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.tooling;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xenei.junit.contract.ClassPathUtils;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.ContractImpl;
import org.xenei.junit.contract.NoContractTest;
import org.xenei.junit.contract.info.ContractTestMap;
import org.xenei.junit.contract.info.TestInfo;
import org.xenei.junit.contract.tooling.InterfaceInfo;

public class InterfaceReport {
    private final Collection<Class<?>> packageClasses;
    private final Collection<Class<?>> skipClasses;
    private Map<Class<?>, InterfaceInfo> interfaceInfoMap;
    private final ContractTestMap contractTestMap;
    private final ContractImplMap contractImplMap;
    private static final Logger LOG = LoggerFactory.getLogger(ContractTestMap.class);
    private static final Comparator<Class<?>> CLASS_NAME_COMPARATOR = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    private boolean isInterestingInterface(Class<?> clazz) {
        return clazz.isInterface() && !clazz.isAnnotation() && null == clazz.getAnnotation(NoContractTest.class) && !this.skipClasses.contains(clazz);
    }

    public Collection<InterfaceInfo> getInterfaceInfoCollection() {
        return this.getInterfaceInfoMap().values();
    }

    private Map<Class<?>, InterfaceInfo> getInterfaceInfoMap() {
        if (this.interfaceInfoMap == null) {
            this.interfaceInfoMap = new HashMap();
            for (Class<?> c : this.packageClasses) {
                if (this.isInterestingInterface(c)) {
                    if (this.interfaceInfoMap.containsKey(c)) continue;
                    this.interfaceInfoMap.put(c, new InterfaceInfo(c));
                    continue;
                }
                Contract contract = c.getAnnotation(Contract.class);
                if (contract == null) continue;
                InterfaceInfo ii = this.interfaceInfoMap.get(contract.value());
                if (ii == null) {
                    ii = new InterfaceInfo(contract.value());
                    this.interfaceInfoMap.put(contract.value(), ii);
                }
                ii.add(c);
            }
        }
        return this.interfaceInfoMap;
    }

    public InterfaceReport(String[] packages, String[] skipClasses, ClassLoader classLoader) throws MalformedURLException {
        if (packages.length == 0) {
            throw new IllegalArgumentException("At least one package must be specified");
        }
        this.contractTestMap = ContractTestMap.populateInstance(classLoader, packages);
        this.packageClasses = new HashSet();
        for (String p : packages) {
            this.packageClasses.addAll(ClassPathUtils.getClasses(classLoader, p));
        }
        if (this.packageClasses.size() == 0) {
            throw new IllegalArgumentException("No classes found in " + packages);
        }
        this.skipClasses = new HashSet();
        if (skipClasses != null) {
            for (String s : skipClasses) {
                try {
                    this.skipClasses.add(Class.forName(s, false, classLoader));
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Skip class {} was not found", (Object)s);
                }
            }
        }
        this.contractImplMap = ContractImplMap.populateInstance(this.packageClasses);
    }

    public Collection<Class<?>> getPackageClasses() {
        return this.packageClasses;
    }

    public List<Throwable> getErrors() {
        ArrayList<Throwable> retval = new ArrayList<Throwable>();
        for (TestInfo testInfo : this.contractTestMap.listTestInfo()) {
            retval.addAll(testInfo.getErrors());
        }
        return retval;
    }

    public Set<Class<?>> getUntestedInterfaces() {
        TreeSet retval = new TreeSet(CLASS_NAME_COMPARATOR);
        for (InterfaceInfo info : this.getInterfaceInfoMap().values()) {
            if (!info.getTests().isEmpty() || info.getName().getDeclaredMethods().length <= 0) continue;
            retval.add(info.getName());
        }
        return retval;
    }

    public Set<Class<?>> getUnImplementedTests() {
        TreeSet retval = new TreeSet(CLASS_NAME_COMPARATOR);
        for (Class<?> clazz : this.packageClasses) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || this.skipClasses.contains(clazz)) continue;
            LOG.debug("checking {} for contract tests", clazz);
            Set<Class<Class<?>>> interfaces = ClassPathUtils.getAllInterfaces(clazz);
            Map<Class<?>, InterfaceInfo> interfaceInfo = this.getInterfaceInfoMap();
            interfaces.retainAll(interfaceInfo.keySet());
            if (interfaces.isEmpty() || this.contractImplMap.hasTestFor(clazz)) continue;
            retval.add(clazz);
        }
        return retval;
    }

    public static void main(String[] args) throws ParseException, MalformedURLException {
        HelpFormatter formatter;
        CommandLine commands = new BasicParser().parse(InterfaceReport.getOptions(), args);
        if (commands.hasOption("h")) {
            formatter = new HelpFormatter();
            formatter.printHelp("InterfaceReport", InterfaceReport.getOptions());
            System.exit(0);
        }
        if (!commands.hasOption("p")) {
            System.out.println("At least on package must be specified");
            formatter = new HelpFormatter();
            formatter.printHelp("InterfaceReport", InterfaceReport.getOptions());
            System.exit(1);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (commands.hasOption("d")) {
            String[] dirs = commands.getOptionValues("d");
            URL[] urls = null;
            urls = new URL[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                urls[i] = new File(dirs[i]).toURI().toURL();
            }
            classLoader = new URLClassLoader(urls, classLoader);
        }
        InterfaceReport ifReport = new InterfaceReport(commands.getOptionValues("p"), commands.getOptionValues("s"), classLoader);
        if (commands.hasOption("u")) {
            System.out.println("Untested Interfaces");
            for (Class<?> c : ifReport.getUntestedInterfaces()) {
                System.out.println(c.getCanonicalName());
            }
            System.out.println("End of Report");
        }
        if (commands.hasOption("i")) {
            System.out.println("Missing contract test implementations");
            for (Class<?> c : ifReport.getUnImplementedTests()) {
                System.out.println(c.getName());
            }
            System.out.println("End of Report");
        }
        if (commands.hasOption("e")) {
            System.out.println("Misconfigured contract test report");
            for (Throwable t : ifReport.getErrors()) {
                System.out.println(t.toString());
            }
            System.out.println("End of Report");
        }
    }

    private static Options getOptions() {
        Options retval = new Options();
        retval.addOption("h", "help", false, "Display this help page");
        retval.addOption("p", "package", true, "Package to be scanned");
        retval.addOption("d", "directory", true, "Directory to be scanned for classes");
        retval.addOption("u", "untested", false, "Produce untested class report");
        retval.addOption("i", "implementation", false, "Produce missing implementation report");
        retval.addOption("e", "errors", false, "Produce contract test configuration error report");
        retval.addOption("s", "skipInterfaces", true, "A list of interfaces that should not have tests.  See also @NoContractTest annotation");
        return retval;
    }

    private static class ContractImplMap {
        private final Map<Class<?>, Set<Class<?>>> forwardMap = new HashMap();
        private final Map<Class<?>, Class<?>> reverseMap = new HashMap();

        public static ContractImplMap populateInstance(Collection<Class<?>> classes) {
            ContractImplMap retval = new ContractImplMap();
            for (Class<?> c : classes) {
                ContractImpl contractImpl = c.getAnnotation(ContractImpl.class);
                if (contractImpl == null) continue;
                retval.add(c, contractImpl);
            }
            return retval;
        }

        private void add(Class<?> contractTestImplClass, ContractImpl contractImpl) {
            Set<Class<?>> set = this.forwardMap.get(contractImpl.value());
            if (set == null) {
                set = new HashSet();
                this.forwardMap.put(contractImpl.value(), set);
            }
            set.add(contractTestImplClass);
            this.reverseMap.put(contractTestImplClass, contractImpl.value());
        }

        public boolean hasTestFor(Class<?> contractTestImplClass) {
            return this.forwardMap.containsKey(contractTestImplClass);
        }
    }
}

