/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.xenei.junit.contract.filter.ClassFilter;
import org.xenei.junit.contract.filter.ConditionalClassFilter;

public abstract class AbstractConditionalClassFilter
implements ConditionalClassFilter {
    private final List<ClassFilter> classFilters = new ArrayList<ClassFilter>();

    protected AbstractConditionalClassFilter(Collection<ClassFilter> classFilters) {
        if (classFilters == null || classFilters.size() < 2) {
            throw new IllegalArgumentException("Collection of filters may not be null or contain less than 2 filters");
        }
        this.addClassFilters(classFilters);
    }

    protected AbstractConditionalClassFilter(ClassFilter ... classFilters) {
        if (classFilters.length < 2) {
            throw new IllegalArgumentException("Array of filters may not contain less than 2 filters");
        }
        this.addClassFilters(classFilters);
    }

    @Override
    public String[] args() {
        String[] retval = new String[this.classFilters.size()];
        for (int i = 0; i < this.classFilters.size(); ++i) {
            retval[i] = this.classFilters.get(i).toString();
        }
        return retval;
    }

    @Override
    public Collection<Class<?>> filter(Collection<Class<?>> collection) {
        return ClassFilter.Util.filterClasses(collection, this);
    }

    @Override
    public Collection<String> filterNames(Collection<String> collection) {
        return ClassFilter.Util.filterClassNames(collection, this);
    }

    protected boolean isFilterListEmpty() {
        return this.classFilters.isEmpty();
    }

    @Override
    public final void addClassFilter(ClassFilter classFilter) {
        if (classFilter == null) {
            throw new IllegalArgumentException("classFilter may not be null");
        }
        this.classFilters.add(classFilter);
    }

    @Override
    public final List<ClassFilter> getClassFilters() {
        return Collections.unmodifiableList(this.classFilters);
    }

    @Override
    public final boolean removeClassFilter(ClassFilter classFilter) {
        return this.classFilters.remove(classFilter);
    }

    @Override
    public final void setClassFilters(Collection<ClassFilter> classFilters) {
        this.classFilters.clear();
        this.addClassFilters(classFilters);
    }

    @Override
    public final void addClassFilters(Collection<ClassFilter> classFilters) {
        for (ClassFilter filter : classFilters) {
            this.addClassFilter(filter);
        }
    }

    @Override
    public final void setClassFilters(ClassFilter ... classFilters) {
        this.classFilters.clear();
        this.addClassFilters(classFilters);
    }

    @Override
    public final void addClassFilters(ClassFilter ... classFilters) {
        for (ClassFilter filter : classFilters) {
            this.addClassFilter(filter);
        }
    }

    @Override
    public final void removeClassFilters(Collection<ClassFilter> classFilters) {
        this.classFilters.removeAll(classFilters);
    }

    @Override
    public final void removeClassFilters(ClassFilter ... classFilters) {
        this.classFilters.removeAll(Arrays.asList(classFilters));
    }

    public String toString() {
        return ClassFilter.Util.toString(this);
    }
}

