/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.filter;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.xenei.junit.contract.filter.ClassFilter;

public class HasAnnotationClassFilter
implements ClassFilter,
Serializable {
    private static final long serialVersionUID = 4258956807308815129L;
    private Class<? extends Annotation> annotation;

    public HasAnnotationClassFilter(Class<? extends Annotation> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation may not be null");
        }
        this.annotation = annotation;
    }

    @Override
    public String funcName() {
        return "HasAnnotation";
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return null != clazz.getAnnotation(this.annotation);
    }

    @Override
    public boolean accept(String className) {
        try {
            return this.accept(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        return ClassFilter.Util.toString(this);
    }

    @Override
    public String[] args() {
        return new String[]{this.annotation.getName()};
    }

    @Override
    public Collection<Class<?>> filter(Collection<Class<?>> collection) {
        return ClassFilter.Util.filterClasses(collection, this);
    }

    @Override
    public Collection<String> filterNames(Collection<String> collection) {
        return ClassFilter.Util.filterClassNames(collection, this);
    }
}

