/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.info;

import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.xenei.junit.contract.info.TestInfo;

public class TestInfoErrorRunner
extends Runner {
    private final TestInfo testInfo;
    private final Class<?> fTestClass;

    public TestInfoErrorRunner(Class<?> testClass, TestInfo testInfo) {
        this.fTestClass = testClass;
        this.testInfo = testInfo;
    }

    public void logErrors(Logger log) {
        for (Throwable t : this.testInfo.getErrors()) {
            log.error(t.toString());
        }
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.testInfo.getContractTestClass());
        for (Throwable each : this.testInfo.getErrors()) {
            description.addChild(this.describeCause(each));
        }
        return description;
    }

    public void run(RunNotifier notifier) {
        for (Throwable each : this.testInfo.getErrors()) {
            this.runCause(each, notifier);
        }
    }

    private Description describeCause(Throwable child) {
        return Description.createTestDescription(this.testInfo.getContractTestClass(), (String)String.format("%s(%s)", this.testInfo.getContractTestClass().getSimpleName(), this.fTestClass.getSimpleName()));
    }

    private void runCause(Throwable child, RunNotifier notifier) {
        Description description = this.describeCause(child);
        notifier.fireTestStarted(description);
        notifier.fireTestFailure(new Failure(description, child));
        notifier.fireTestFinished(description);
    }

    public String toString() {
        return String.format("TestInfoErrorRunner[ %s ]", this.testInfo);
    }
}

