/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xenei.junit.contract.filter.ClassFilter;
import org.xenei.junit.contract.filter.PrefixClassFilter;

public class ClassPathUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathUtils.class);

    public static Set<String> findClasses(String directory, String packageName) throws IOException {
        return ClassPathUtils.findClasses(directory, packageName, new PrefixClassFilter(packageName));
    }

    private static void handleJar(Set<String> classes, String directory, ClassFilter filter) throws IOException {
        String[] split = directory.split("!");
        URL jar = new URL(split[0]);
        ZipInputStream zip = new ZipInputStream(jar.openStream());
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            String className;
            if (!entry.getName().endsWith(".class") || !filter.accept(className = entry.getName().replaceAll("\\$.*", "").replaceAll("\\.class", "").replace('/', '.'))) continue;
            classes.add(className);
        }
    }

    private static void handleDir(Set<String> classes, String packageName, File dir, ClassFilter cFilter) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            for (File file : dir.listFiles((FileFilter)new WildcardFileFilter("*.class"))) {
                ClassPathUtils.handleDir(classes, packageName, file, cFilter);
            }
            for (File file : dir.listFiles((FileFilter)new AndFileFilter(DirectoryFileFilter.DIRECTORY, (IOFileFilter)new NotFileFilter((IOFileFilter)new PrefixFileFilter("."))))) {
                String newPkgName = String.format("%s%s%s", packageName, packageName.length() > 0 ? "." : "", file.getName());
                ClassPathUtils.handleDir(classes, newPkgName, file, cFilter);
            }
        } else if (dir.getName().endsWith(".class")) {
            String className = String.format("%s%s%s", packageName, packageName.length() > 0 ? "." : "", dir.getName());
            if (cFilter.accept(className = className.substring(0, className.length() - ".class".length()))) {
                classes.add(className);
            }
        }
    }

    private static void scanDir(Set<String> classes, String packageName, File dir, ClassFilter cFilter) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            if (dir.getPath().endsWith(packageName.replace('.', '/'))) {
                ClassPathUtils.handleDir(classes, packageName, dir, cFilter);
            } else {
                for (File file : dir.listFiles((FileFilter)new AndFileFilter(DirectoryFileFilter.DIRECTORY, (IOFileFilter)new NotFileFilter((IOFileFilter)new PrefixFileFilter("."))))) {
                    ClassPathUtils.scanDir(classes, packageName, file, cFilter);
                }
            }
        }
    }

    public static Set<String> findClasses(String directory, String packageName, ClassFilter filter) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        if (directory.startsWith("file:")) {
            if (directory.contains("!")) {
                ClassPathUtils.handleJar(classes, directory, filter);
            } else {
                ClassPathUtils.scanDir(classes, packageName, new File(directory.substring("file:".length())), filter);
            }
        } else {
            ClassPathUtils.scanDir(classes, packageName, new File(directory), filter);
        }
        return classes;
    }

    public static Collection<Class<?>> getClasses(String packageName) {
        return ClassPathUtils.getClasses(packageName, new PrefixClassFilter(packageName));
    }

    public static Collection<Class<?>> getClasses(String packageName, ClassFilter filter) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            LOG.error("Class loader may not be null.  No class loader for current thread");
            return Collections.emptyList();
        }
        return ClassPathUtils.getClasses(classLoader, packageName, filter);
    }

    public static Collection<Class<?>> getClasses(ClassLoader classLoader, String packageName) {
        return ClassPathUtils.getClasses(classLoader, packageName, new PrefixClassFilter(packageName));
    }

    public static Collection<Class<?>> getClasses(ClassLoader classLoader, String packageName, ClassFilter filter) {
        HashSet classes;
        block13: {
            block12: {
                Enumeration<URL> resources;
                if (classLoader == null) {
                    LOG.error("Class loader may not be null.");
                    return Collections.emptyList();
                }
                if (packageName == null) {
                    LOG.error("Package name may not be null.");
                    return Collections.emptyList();
                }
                String dirName = packageName.replace('.', '/');
                try {
                    resources = classLoader.getResources(dirName);
                }
                catch (IOException e1) {
                    LOG.error(e1.toString());
                    return Collections.emptyList();
                }
                classes = new HashSet();
                HashSet<String> directories = new HashSet<String>();
                if (!resources.hasMoreElements()) break block12;
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    String dir = resource.getPath();
                    if (directories.contains(dir)) continue;
                    directories.add(dir);
                    try {
                        for (String clazz : ClassPathUtils.findClasses(dir, packageName, filter)) {
                            try {
                                LOG.debug("Adding class {}", (Object)clazz);
                                classes.add(Class.forName(clazz, false, classLoader));
                            }
                            catch (ClassNotFoundException e) {
                                LOG.warn(e.toString());
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.warn(e.toString());
                    }
                }
                break block13;
            }
            if (packageName.length() <= 0) break block13;
            try {
                classes.add(Class.forName(packageName, false, classLoader));
            }
            catch (ClassNotFoundException e) {
                LOG.warn(String.format("'%s' was neither a package name nor a class name", packageName));
            }
        }
        return classes;
    }

    public static Set<Class<?>> filterClasses(Collection<Class<?>> classes, ClassFilter filter) {
        HashSet retval = new HashSet();
        for (Class<?> clazz : classes) {
            if (!filter.accept(clazz)) continue;
            retval.add(clazz);
        }
        return retval;
    }

    public static Set<String> filterClassNames(Collection<String> classNames, ClassFilter filter) {
        HashSet<String> retval = new HashSet<String>();
        for (String className : classNames) {
            if (!filter.accept(className)) continue;
            retval.add(className);
        }
        return retval;
    }

    public static String[] getClassPathElements() {
        String splitter = String.format("\\%s", System.getProperty("path.separator"));
        String[] classPath = System.getProperty("java.class.path").split(splitter);
        return classPath;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        LinkedHashSet implClasses = new LinkedHashSet();
        ClassPathUtils.getAllInterfaces(implClasses, clazz);
        return implClasses;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz, ClassFilter filter) {
        return ClassPathUtils.filterClasses(ClassPathUtils.getAllInterfaces(clazz), filter);
    }

    public static void getAllInterfaces(Set<Class<?>> set, Class<?> c) {
        if (c == null || c == Object.class) {
            return;
        }
        for (Class<?> i : c.getClasses()) {
            if (!i.isInterface() || set.contains(i)) continue;
            set.add(i);
            ClassPathUtils.getAllInterfaces(set, i);
        }
        for (Class<?> i : c.getInterfaces()) {
            if (set.contains(i)) continue;
            set.add(i);
            ClassPathUtils.getAllInterfaces(set, i);
        }
        ClassPathUtils.getAllInterfaces(set, c.getSuperclass());
    }
}

