/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.xenei.junit.contract.ContractTest;
import org.xenei.junit.contract.info.DynamicTestInfo;
import org.xenei.junit.contract.info.TestInfo;

public class ContractTestRunner
extends BlockJUnit4ClassRunner {
    private final TestInfo parentTestInfo;
    private final TestInfo testInfo;
    private final Object getterObj;
    private final Method getter;

    public ContractTestRunner(Object getterObj, TestInfo parentTestInfo, TestInfo testInfo) throws InitializationError {
        super(testInfo.getContractTestClass());
        this.parentTestInfo = parentTestInfo;
        this.testInfo = testInfo;
        this.getterObj = getterObj;
        this.getter = parentTestInfo.getMethod();
    }

    public ContractTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.parentTestInfo = null;
        this.testInfo = null;
        this.getterObj = null;
        this.getter = null;
    }

    protected Object createTest() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object retval = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        if (this.parentTestInfo != null) {
            if (this.parentTestInfo instanceof DynamicTestInfo) {
                DynamicTestInfo dti = (DynamicTestInfo)this.parentTestInfo;
                Object baseProducer = dti.getDynamicInjector().invoke(this.getterObj, new Object[0]);
                this.testInfo.getMethod().invoke(retval, dti.getProducer(baseProducer));
            } else {
                this.testInfo.getMethod().invoke(retval, this.getter.invoke(this.getterObj, new Object[0]));
            }
        }
        return retval;
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected String getName() {
        return this.testInfo == null ? super.getName() : this.testInfo.getContractTestClass().getName();
    }

    protected Description describeChild(FrameworkMethod method) {
        if (this.testInfo == null) {
            return super.describeChild(method);
        }
        if (this.parentTestInfo == null) {
            return Description.createTestDescription(this.testInfo.getContractTestClass(), (String)this.testName(method), (Annotation[])method.getAnnotations());
        }
        String name = String.format("%s(%s)", this.testName(method), this.testInfo.getContractTestClass().getSimpleName());
        return Description.createTestDescription(this.parentTestInfo.getContractTestClass(), (String)name, (Annotation[])method.getAnnotations());
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(ContractTest.class);
    }
}

