/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.xenei.junit.contract.filter.AbstractBaseClassFilter;
import org.xenei.junit.contract.filter.Case;
import org.xenei.junit.contract.filter.ClassFilter;

public abstract class AbstractStringClassFilter
extends AbstractBaseClassFilter {
    private final List<String> strings = new ArrayList<String>();
    protected final Case caseSensitivity;

    protected AbstractStringClassFilter(String str) {
        this((Case)null, str);
    }

    protected AbstractStringClassFilter(Case caseSensitivity, String str) {
        this.caseSensitivity = caseSensitivity == null ? Case.SENSITIVE : caseSensitivity;
        this.addString(str);
    }

    protected AbstractStringClassFilter(String ... strings) {
        this((Case)null, strings);
    }

    protected AbstractStringClassFilter(Case caseSensitivity, String ... strings) {
        if (strings == null || strings.length < 1) {
            throw new IllegalArgumentException("List of strings may not be null or null length");
        }
        this.caseSensitivity = caseSensitivity == null ? Case.SENSITIVE : caseSensitivity;
        this.addStrings(strings);
    }

    protected AbstractStringClassFilter(Collection<String> strings) {
        this((Case)null, strings.toArray(new String[strings.size()]));
    }

    protected AbstractStringClassFilter(Case caseSensitivity, Collection<String> strings) {
        this(caseSensitivity, strings.toArray(new String[strings.size()]));
    }

    @Override
    public String[] args() {
        String[] retval = new String[this.strings.size() + 1];
        retval[0] = this.caseSensitivity.getName();
        for (int i = 0; i < this.strings.size(); ++i) {
            retval[i + 1] = this.strings.get(i);
        }
        return retval;
    }

    public final void addString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("The string must not be null");
        }
        this.strings.add(str);
    }

    public final void addStrings(Collection<String> strings) {
        if (strings == null) {
            throw new IllegalArgumentException("The strings must not be null");
        }
        for (String s : strings) {
            this.addString(s);
        }
    }

    public final void addStrings(String ... strings) {
        if (strings == null) {
            throw new IllegalArgumentException("The strings must not be null");
        }
        for (String s : strings) {
            this.addString(s);
        }
    }

    public final List<String> getStrings() {
        return Collections.unmodifiableList(this.strings);
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return this.accept(clazz.getName());
    }

    @Override
    public String toString() {
        return ClassFilter.Util.toString(this);
    }
}

