/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.filter;

import java.util.ArrayList;
import java.util.Collection;
import org.xenei.junit.contract.filter.AbstractClassFilter;
import org.xenei.junit.contract.filter.AnnotationClassFilter;
import org.xenei.junit.contract.filter.FalseClassFilter;
import org.xenei.junit.contract.filter.InterfaceClassFilter;
import org.xenei.junit.contract.filter.TrueClassFilter;

public interface ClassFilter {
    public static final ClassFilter TRUE = TrueClassFilter.TRUE;
    public static final ClassFilter FALSE = FalseClassFilter.FALSE;
    public static final ClassFilter ANNOTATION = AnnotationClassFilter.ANNOTATION;
    public static final ClassFilter ABSTRACT = AbstractClassFilter.ABSTRACT;
    public static final ClassFilter INTERFACE = InterfaceClassFilter.INTERFACE;

    public boolean accept(Class<?> var1);

    public boolean accept(String var1);

    public String funcName();

    public Collection<Class<?>> filter(Collection<Class<?>> var1);

    public Collection<String> filterNames(Collection<String> var1);

    public String[] args();

    public static class Util {
        public static Collection<Class<?>> filterClasses(Collection<Class<?>> classes, ClassFilter filter) {
            ArrayList retval = new ArrayList();
            for (Class<?> clazz : classes) {
                if (!filter.accept(clazz)) continue;
                retval.add(clazz);
            }
            return retval;
        }

        public static Collection<String> filterClassNames(Collection<String> classNames, ClassFilter filter) {
            ArrayList<String> retval = new ArrayList<String>();
            for (String className : classNames) {
                if (!filter.accept(className)) continue;
                retval.add(className);
            }
            return retval;
        }

        public static String toString(ClassFilter filter) {
            StringBuilder sb = new StringBuilder(filter.funcName()).append("(");
            String[] args = filter.args();
            if (args.length > 0) {
                sb.append(" ");
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(args[i]);
                }
                sb.append(" ");
            }
            return sb.append(")").toString();
        }

        public static String parseArgs(String str, int pos) {
            int cnt = 1;
            block4: for (int i = pos + 1; i < str.length(); ++i) {
                switch (str.charAt(i)) {
                    case '(': {
                        ++cnt;
                        continue block4;
                    }
                    case ')': {
                        if (--cnt != 0) continue block4;
                        return str.substring(pos, i - 1);
                    }
                }
            }
            throw new IllegalArgumentException("Can not parse " + str);
        }
    }
}

