/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.info;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Ignore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xenei.junit.contract.ClassPathUtils;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.filter.AndClassFilter;
import org.xenei.junit.contract.filter.ClassFilter;
import org.xenei.junit.contract.filter.HasAnnotationClassFilter;
import org.xenei.junit.contract.filter.NameClassFilter;
import org.xenei.junit.contract.filter.NotClassFilter;
import org.xenei.junit.contract.filter.OrClassFilter;
import org.xenei.junit.contract.filter.PrefixClassFilter;
import org.xenei.junit.contract.info.TestInfo;

public class ContractTestMap {
    private final Map<Class<?>, TestInfo> classToInfoMap = new HashMap();
    private final Map<Class<?>, Set<TestInfo>> interfaceToInfoMap = new HashMap();
    private static final ClassFilter SKIP_FILTER;
    private static final Logger LOG;

    public static ContractTestMap populateInstance() {
        return ContractTestMap.populateInstance(ClassFilter.TRUE, ClassFilter.FALSE);
    }

    private static ClassFilter createIgnoreFilter(ClassFilter ignoreFilter) {
        return new AndClassFilter(new NotClassFilter(SKIP_FILTER), new NotClassFilter(ignoreFilter), new HasAnnotationClassFilter(Contract.class), new NotClassFilter(new HasAnnotationClassFilter(Ignore.class)));
    }

    public static ContractTestMap populateInstance(ClassFilter packageFilter, ClassFilter ignoreFilter) {
        ContractTestMap retval = new ContractTestMap();
        AndClassFilter filter = new AndClassFilter(packageFilter, ContractTestMap.createIgnoreFilter(ignoreFilter));
        for (Class<?> clazz : ClassPathUtils.getClasses("", filter)) {
            Contract c = clazz.getAnnotation(Contract.class);
            LOG.debug("adding {} {}", clazz, (Object)c);
            retval.add(new TestInfo(clazz, c));
        }
        return retval;
    }

    public static ContractTestMap populateInstance(ClassLoader classLoader) {
        return ContractTestMap.populateInstance(classLoader, ClassFilter.FALSE, ClassFilter.TRUE);
    }

    public static ContractTestMap populateInstance(ClassLoader classLoader, ClassFilter packageFilter, ClassFilter ignoreFilter) {
        AndClassFilter filter = new AndClassFilter(packageFilter, ContractTestMap.createIgnoreFilter(ignoreFilter));
        return ContractTestMap.populateInstance(classLoader, (ClassFilter)filter);
    }

    public static ContractTestMap populateInstance(ClassLoader classLoader, String[] packages) {
        return ContractTestMap.populateInstance(classLoader, (ClassFilter)new PrefixClassFilter(packages));
    }

    public static ContractTestMap populateInstance(ClassLoader classLoader, ClassFilter filter) {
        ContractTestMap retval = new ContractTestMap();
        AndClassFilter fltr = new AndClassFilter(filter, new HasAnnotationClassFilter(Contract.class));
        for (Class<?> clazz : ClassPathUtils.getClasses(classLoader, "", fltr)) {
            Contract c = clazz.getAnnotation(Contract.class);
            if (c == null) continue;
            retval.add(new TestInfo(clazz, c));
        }
        return retval;
    }

    public void add(TestInfo info) {
        this.classToInfoMap.put(info.getContractTestClass(), info);
        Set<TestInfo> tiSet = this.interfaceToInfoMap.get(info.getInterfaceClass());
        if (tiSet == null) {
            tiSet = new HashSet<TestInfo>();
            this.interfaceToInfoMap.put(info.getInterfaceClass(), tiSet);
        }
        tiSet.add(info);
    }

    public TestInfo getInfoByTestClass(Class<?> testClass) {
        return this.classToInfoMap.get(testClass);
    }

    public Set<TestInfo> getInfoByInterfaceClass(Class<?> contract) {
        Set<TestInfo> ti = this.interfaceToInfoMap.get(contract);
        if (ti == null) {
            LOG.info(String.format("Found no tests for interface %s.", contract));
            return Collections.emptySet();
        }
        return this.interfaceToInfoMap.get(contract);
    }

    public Set<TestInfo> getAnnotatedClasses(TestInfo contractClassInfo) {
        return this.getAnnotatedClasses(new LinkedHashSet<TestInfo>(), contractClassInfo);
    }

    public Set<TestInfo> getAnnotatedClasses(Set<TestInfo> testClasses, TestInfo contractClassInfo) {
        Set<Class<?>> implClasses = ClassPathUtils.getAllInterfaces(contractClassInfo.getInterfaceClass());
        List<Class<?>> skipList = Arrays.asList(contractClassInfo.getSkipTests());
        for (Class<?> clazz : implClasses) {
            if (skipList.contains(clazz)) {
                LOG.info(String.format("Skipping %s for %s", clazz, contractClassInfo));
                continue;
            }
            testClasses.addAll(this.getInfoByInterfaceClass(clazz));
        }
        return testClasses;
    }

    public Collection<TestInfo> listTestInfo() {
        return this.classToInfoMap.values();
    }

    static {
        LOG = LoggerFactory.getLogger(ContractTestMap.class);
        String prop = System.getProperty("contracts.skipClasses");
        if (prop != null) {
            ClassFilter cf = null;
            for (String iFace : prop.split(",")) {
                if (cf == null) {
                    cf = new NameClassFilter(iFace.trim());
                    continue;
                }
                if (cf instanceof NameClassFilter) {
                    cf = new OrClassFilter(cf, new NameClassFilter(iFace.trim()));
                    continue;
                }
                ((OrClassFilter)cf).addClassFilter(new NameClassFilter(iFace.trim()));
            }
            SKIP_FILTER = cf;
        } else {
            SKIP_FILTER = ClassFilter.FALSE;
        }
    }
}

