/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.log4j.recording;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.xenei.log4j.recording.selector.Selector;

public class RecordingAppender
extends AppenderSkeleton {
    private final List<LoggingEvent> history = new ArrayList<LoggingEvent>();

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent event) {
        this.history.add(event);
    }

    private final boolean has(Selector selector, List<LoggingEvent> event1, List<LoggingEvent> event2) {
        if (event1.size() != event2.size()) {
            return false;
        }
        for (int i = 0; i < event1.size(); ++i) {
            if (selector.matches(event1.get(i), event2.get(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean has(Selector selector, List<LoggingEvent> things) {
        return this.has(selector, things, this.history);
    }

    public final boolean hasStart(Selector selector, List<LoggingEvent> events) {
        if (events.size() <= this.history.size()) {
            return this.has(selector, events, this.history.subList(0, events.size()));
        }
        return false;
    }

    public final boolean hasEnd(Selector selector, List<LoggingEvent> events) {
        if (events.size() <= this.history.size()) {
            return this.has(selector, events, this.history.subList(this.history.size() - events.size(), this.history.size()));
        }
        return false;
    }

    public final void assertHas(Selector selector, List<LoggingEvent> events) {
        if (!this.has(selector, events)) {
            Assert.fail((String)("expected " + this.asStrings(events) + " but got " + this.asStrings(this.history)));
        }
    }

    private List<String> asStrings(LoggingEvent ... events) {
        return this.asStrings(Arrays.asList(events));
    }

    private List<String> asStrings(List<LoggingEvent> events) {
        ArrayList<String> retval = new ArrayList<String>(events.size());
        for (LoggingEvent e : events) {
            retval.add(e.getMessage().toString());
        }
        return retval;
    }

    public final void assertContains(Selector selector, LoggingEvent ... events) {
        if (!this.contains(selector, events)) {
            Assert.fail((String)String.format("Did not find %s in the logging history: %s", this.asStrings(events), this.asStrings(this.history)));
        }
    }

    public final void assertHasStart(Selector selector, LoggingEvent ... start) {
        List<LoggingEvent> startList = Arrays.asList(start);
        if (!this.hasStart(selector, startList)) {
            Assert.fail((String)("expected " + this.asStrings(startList) + " at the beginning of " + this.asStrings(this.history)));
        }
    }

    public final void assertHasEnd(Selector selector, LoggingEvent ... end) {
        List<LoggingEvent> endList = Arrays.asList(end);
        if (!this.hasEnd(selector, endList)) {
            Assert.fail((String)("expected " + this.asStrings(endList) + " at the end of " + this.asStrings(this.history)));
        }
    }

    public final void clear() {
        this.history.clear();
    }

    public final boolean contains(Selector selector, LoggingEvent ... events) {
        for (int i = 0; i < this.history.size(); ++i) {
            if (!selector.matches(this.history.get(i), events[0])) continue;
            boolean found = true;
            for (int j = 1; j < events.length; ++j) {
                if (i + j >= this.history.size()) {
                    found = false;
                    break;
                }
                if (selector.matches(this.history.get(i + j), events[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public final Iterator<LoggingEvent> getEvents() {
        return this.history.iterator();
    }

    public final Iterator<LoggingEvent> from(Selector selector, LoggingEvent start) {
        Iterator<LoggingEvent> iter = this.history.iterator();
        while (iter.hasNext() && !selector.matches(iter.next(), start)) {
        }
        return iter;
    }
}

