/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Node;
import org.xeustechnologies.jcl.JclObjectFactory;
import org.xeustechnologies.jcl.exception.JclException;

public class JclBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    private static final String JCL_REF = "ref";
    private static final String JCL_FACTORY = "jcl-factory-" + UUID.randomUUID();
    private static final String JCL_FACTORY_METHOD = "create";
    private static final String JCL_FACTORY_CONSTRUCTOR = "getInstance";

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder holder, ParserContext parserContext) {
        String jclRef = node.getAttributes().getNamedItem(JCL_REF).getNodeValue();
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setFactoryBeanName(JCL_FACTORY);
        bd.setFactoryMethodName(JCL_FACTORY_METHOD);
        bd.setConstructorArgumentValues(holder.getBeanDefinition().getConstructorArgumentValues());
        bd.setPropertyValues(holder.getBeanDefinition().getPropertyValues());
        bd.getConstructorArgumentValues().addIndexedArgumentValue(0, new ConstructorArgumentValues.ValueHolder((Object)parserContext.getRegistry().getBeanDefinition(jclRef)));
        bd.getConstructorArgumentValues().addIndexedArgumentValue(1, new ConstructorArgumentValues.ValueHolder((Object)holder.getBeanDefinition().getBeanClassName()));
        BeanDefinitionHolder newHolder = new BeanDefinitionHolder((BeanDefinition)bd, holder.getBeanName());
        this.createDependencyOnJcl(node, newHolder, parserContext);
        return newHolder;
    }

    private void createDependencyOnJcl(Node node, BeanDefinitionHolder holder, ParserContext parserContext) {
        String[] dependsOn;
        AbstractBeanDefinition definition = (AbstractBeanDefinition)holder.getBeanDefinition();
        String jclRef = node.getAttributes().getNamedItem(JCL_REF).getNodeValue();
        if (!parserContext.getRegistry().containsBeanDefinition(JCL_FACTORY)) {
            BeanDefinitionBuilder initializer = BeanDefinitionBuilder.rootBeanDefinition(JclObjectFactory.class, (String)JCL_FACTORY_CONSTRUCTOR);
            parserContext.getRegistry().registerBeanDefinition(JCL_FACTORY, (BeanDefinition)initializer.getBeanDefinition());
        }
        if (parserContext.getRegistry().containsBeanDefinition(jclRef)) {
            dependsOn = definition.getDependsOn();
            if (dependsOn == null) {
                dependsOn = new String[]{jclRef, JCL_FACTORY};
            } else {
                ArrayList<String> dependencies = new ArrayList<String>(Arrays.asList(dependsOn));
                dependencies.add(jclRef);
                dependencies.add(JCL_FACTORY);
                dependsOn = dependencies.toArray(new String[0]);
            }
        } else {
            throw new JclException("JCL Bean definition " + jclRef + "not found");
        }
        definition.setDependsOn(dependsOn);
    }
}

