/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.xeustechnologies.jcl.JarClassLoader;

public class JclBeanDefinitionParser
implements BeanDefinitionParser {
    private final transient Logger logger = LoggerFactory.getLogger(JclBeanDefinitionParser.class);

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionHolder holder = parserContext.getDelegate().parseBeanDefinitionElement(element);
        String beanName = holder.getBeanName();
        BeanDefinition bd = holder.getBeanDefinition();
        bd.setBeanClassName(JarClassLoader.class.getName());
        this.logger.info("Registering JarClassLoader bean: {}", (Object)beanName);
        parserContext.getRegistry().registerBeanDefinition(beanName, bd);
        return bd;
    }
}

