/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.fn;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xidea.el.Invocable;
import org.xidea.el.fn.ECMA262Impl;
import org.xidea.el.fn.JSObject;
import org.xidea.el.impl.ExpressionFactoryImpl;
import org.xidea.el.json.JSONDecoder;
import org.xidea.el.json.JSONEncoder;

class JSGlobal
implements Invocable {
    static String[] mathArgs = new String[]{"abs", "acos", "asin", "atan", "ceil", "asin", "cos", "exp", "floor", "log", "round", "sin", "sqrt", "tan", "random", "min", "max", "pow", "atan2"};
    final int type;
    private static final Pattern INT_PARTTERN = Pattern.compile("^[\\+\\-]?(0x[0-9a-f]+|0+[0-7]*|[1-9][0-9]*)", 2);
    private static final Pattern FLOAT_PARTTERN = Pattern.compile("^[\\+\\-]?[0-9]*(?:\\.[0-9]+)?");
    private static final Pattern URL_ENCODE_SPLIT = Pattern.compile("[;/?:@&=+$,#]");
    private static final Pattern URL_DECODE_SPLIT = Pattern.compile("\\+|%3B|%2F|%3F|%3A|%40|%26|%3D|%2B|%24|%2C|%23");

    static void setupVar(ExpressionFactoryImpl calculater) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        double LN10 = Math.log(10.0);
        double LN2 = Math.log(2.0);
        map.put("E", Math.E);
        map.put("PI", Math.PI);
        map.put("LN10", LN10);
        map.put("LN2", LN2);
        map.put("LOG2E", 1.0 / LN2);
        map.put("LOG10E", 1.0 / LN10);
        map.put("SQRT1_2", Math.sqrt(0.5));
        map.put("SQRT2", Math.sqrt(2.0));
        for (int i = 0; i < mathArgs.length; ++i) {
            map.put(mathArgs[i], new JSGlobal(i));
        }
        calculater.addVar("Math", map);
        map = new HashMap();
        map.put("parse", new JSGlobal(100));
        map.put("stringify", new JSGlobal(101));
        calculater.addVar("JSON", Collections.unmodifiableMap(map));
        calculater.addVar("isFinite", new JSGlobal(200));
        calculater.addVar("isNaN", new JSGlobal(201));
        calculater.addVar("parseInt", new JSGlobal(300));
        calculater.addVar("parseFloat", new JSGlobal(301));
        calculater.addVar("encodeURI", new JSGlobal(400));
        calculater.addVar("decodeURI", new JSGlobal(401));
        calculater.addVar("encodeURIComponent", new JSGlobal(402));
        calculater.addVar("decodeURIComponent", new JSGlobal(403));
        calculater.addVar("Array", new JSGlobal(500));
        calculater.addVar("Infinity", Double.POSITIVE_INFINITY);
        calculater.addVar("NaN", Double.NaN);
    }

    JSGlobal(int type) {
        this.type = type;
    }

    public String toString() {
        switch (this.type) {
            case 500: {
                return "Array";
            }
            case 400: {
                return "encodeURI";
            }
            case 401: {
                return "decodeURI";
            }
            case 402: {
                return "encodeURIConponent";
            }
            case 403: {
                return "decodeURIComponent";
            }
            case 300: {
                return "parseInt";
            }
            case 301: {
                return "parseFloat";
            }
            case 200: {
                return "isFinite";
            }
            case 201: {
                return "isNaN";
            }
            case 100: {
                return "JSON.parse";
            }
            case 101: {
                return "JSON.stringify";
            }
        }
        if (this.type > 0 && this.type < mathArgs.length) {
            return "Math." + mathArgs[this.type];
        }
        return "unknow method:" + this.type;
    }

    public Object invoke(Object thiz, Object ... args) throws Exception {
        switch (this.type) {
            case 500: {
                double n;
                if (args.length == 1 && args[0] instanceof Number && (n = ((Number)args[0]).doubleValue()) == (double)((int)n) && n >= 0.0) {
                    return new Object[(int)n];
                }
                return args;
            }
            case 400: 
            case 401: 
            case 402: 
            case 403: {
                String text = String.valueOf(JSObject.getArg(args, 0, "null"));
                String charset = String.valueOf(JSObject.getArg(args, 1, "utf-8"));
                return this.edscode(0 == (this.type & 1), this.type < 402, text, charset);
            }
            case 300: 
            case 301: {
                String text = JSObject.getStringArg(args, 0, "").trim();
                if (this.type == 301) {
                    return this.parseFloat(text);
                }
                int radix = JSObject.getNumberArg(args, 1, -1).intValue();
                return this.parseInt(text.trim(), radix);
            }
            case 100: {
                return this.parse(JSObject.getStringArg(args, 0, null));
            }
            case 101: {
                return this.stringify(JSObject.getArg(args, 0, null));
            }
        }
        switch (this.type) {
            case 200: {
                Number n1 = JSObject.getNumberArg(args, 0, null);
                if (n1 == null) {
                    return true;
                }
                return !Double.isNaN(n1.doubleValue()) && !Double.isInfinite(n1.doubleValue());
            }
            case 201: {
                Number n1 = JSObject.getNumberArg(args, 0, null);
                if (n1 == null) {
                    return false;
                }
                return Double.isNaN(n1.doubleValue());
            }
        }
        Number n1 = JSObject.getNumberArg(args, 0, Double.NaN);
        switch (this.type) {
            case 14: {
                return Math.random();
            }
            case 15: {
                return this.mimax(false, args);
            }
            case 16: {
                return this.mimax(true, args);
            }
            case 17: {
                return Math.pow(n1.doubleValue(), JSObject.getNumberArg(args, 1, Double.NaN).doubleValue());
            }
            case 18: {
                return this.atan2(n1.doubleValue(), JSObject.getNumberArg(args, 1, Double.NaN).doubleValue());
            }
            case 0: {
                return this.abs(n1);
            }
            case 1: {
                return this.acos(n1);
            }
            case 2: {
                return this.asin(n1);
            }
            case 3: {
                return this.atan(n1);
            }
            case 4: {
                return this.ceil(n1);
            }
            case 5: {
                return this.asin(n1);
            }
            case 6: {
                return this.cos(n1);
            }
            case 7: {
                return this.exp(n1);
            }
            case 8: {
                return this.floor(n1);
            }
            case 9: {
                return this.log(n1);
            }
            case 10: {
                return this.round(n1);
            }
            case 11: {
                return this.sin(n1);
            }
            case 12: {
                return this.sqrt(n1);
            }
            case 13: {
                return this.tan(n1);
            }
        }
        return 0;
    }

    private final Object mimax(boolean max, Object ... args) throws Exception {
        Number n1 = null;
        for (int i = 0; i < args.length; ++i) {
            Number n2 = ECMA262Impl.ToNumber(JSObject.getArg(args, i, Double.NaN));
            double f2 = n2.floatValue();
            if (f2 == Double.NaN) {
                return n2;
            }
            if (max ? Double.POSITIVE_INFINITY == f2 : Double.NEGATIVE_INFINITY == f2) {
                return n2;
            }
            if (i == 0) {
                n1 = n2;
                continue;
            }
            if (f2 > n1.doubleValue()) {
                if (!max) continue;
                n1 = n2;
                continue;
            }
            if (max) continue;
            n1 = n2;
        }
        return n1;
    }

    private final Object abs(Number x) {
        double d = x.doubleValue();
        if (d < 0.0) {
            return -d;
        }
        return x;
    }

    private final Object acos(Number x) {
        return Math.acos(x.doubleValue());
    }

    private final Object asin(Number x) {
        return Math.asin(x.doubleValue());
    }

    private final Object atan(Number x) {
        return Math.atan(x.doubleValue());
    }

    private final Object atan2(Number x, Number y) {
        return Math.atan2(x.doubleValue(), y.doubleValue());
    }

    private final Object ceil(Number x) {
        return Math.ceil(x.doubleValue());
    }

    private final Object cos(Number x) {
        return Math.cos(x.doubleValue());
    }

    private final Object exp(Number x) {
        return Math.exp(x.doubleValue());
    }

    private final Object floor(Number x) {
        return Math.floor(x.doubleValue());
    }

    private final Object log(Number x) {
        return Math.log(x.doubleValue());
    }

    private final Object round(Number x) {
        return Math.round(x.doubleValue());
    }

    private final Object sin(Number x) {
        return Math.sin(x.doubleValue());
    }

    private final Object sqrt(Number x) {
        return Math.sqrt(x.doubleValue());
    }

    private final Object tan(Number x) {
        return Math.tan(x.doubleValue());
    }

    private final Object parse(Object value) {
        return JSONDecoder.decode(ECMA262Impl.ToPrimitive(value, String.class).toString());
    }

    private final String stringify(Object value) {
        return JSONEncoder.encode(value);
    }

    protected Number parseFloat(String text) {
        Matcher matcher;
        if (text.length() > 0 && (matcher = FLOAT_PARTTERN.matcher(text)).find() && (text = matcher.group(0)).length() > 0) {
            return Double.parseDouble(text);
        }
        return Double.NaN;
    }

    protected Number parseInt(String text, int radix) {
        Matcher matcher = INT_PARTTERN.matcher(text);
        if (matcher.find()) {
            text = matcher.group(0);
            if (radix > 0) {
                return Long.parseLong(text, radix);
            }
            String n = matcher.group(1);
            if (n.charAt(0) == '0') {
                if (n.length() == 1) {
                    return 0;
                }
                char c = n.charAt(1);
                if (c == 'x' || c == 'X') {
                    return Long.parseLong(text.charAt(0) + n.substring(2), 16);
                }
                return Long.parseLong(text, 10);
            }
            return Long.parseLong(text, 10);
        }
        return this.parseFloat(text).intValue();
    }

    protected Object edscode(boolean encode, boolean split, String text, String charset) throws UnsupportedEncodingException {
        if (split) {
            Matcher matcher = (encode ? URL_ENCODE_SPLIT : URL_DECODE_SPLIT).matcher(text);
            StringBuilder buf = new StringBuilder();
            int end = 0;
            while (matcher.find()) {
                int start = matcher.start();
                if (start >= end) {
                    buf.append(this.processPart(encode, text.substring(end, start), charset));
                }
                end = matcher.end();
                buf.append(text.substring(start, end));
            }
            buf.append(this.processPart(encode, text.substring(end), charset));
            return buf.toString();
        }
        return this.processPart(encode, text, charset);
    }

    protected Object processPart(boolean encode, String text, String charset) throws UnsupportedEncodingException {
        return encode ? URLEncoder.encode(text, charset) : URLDecoder.decode(text, charset);
    }
}

