/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.fn;

import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xidea.el.Invocable;
import org.xidea.el.fn.ECMA262Impl;
import org.xidea.el.fn.JSArray;
import org.xidea.el.fn.JSObject;
import org.xidea.el.fn.JSRegExp;

class JSString
extends JSObject
implements Invocable {
    JSString() {
    }

    public String fromCharCode(String thiz, Object[] args) {
        char[] codes = new char[args.length];
        int i = codes.length - 1;
        while (i >= 0) {
            codes[i] = (char)ECMA262Impl.ToNumber(args[i]).intValue();
        }
        return new String(codes);
    }

    public char charAt(String thiz, int p) {
        return thiz.charAt(p);
    }

    public int charCodeAt(String thiz, int p) {
        return thiz.charAt(p);
    }

    public String concat(String thiz, Object[] args) {
        StringBuilder buf = new StringBuilder(thiz);
        for (Object arg : args) {
            buf.append(ECMA262Impl.ToString(arg));
        }
        return buf.toString();
    }

    public int indexOf(String thiz, String sub, int pos) {
        return thiz.indexOf(sub, pos);
    }

    public int lastIndexOf(String thiz, Object[] args) {
        if (args.length > 1) {
            return thiz.lastIndexOf(ECMA262Impl.ToString(args[0]), ECMA262Impl.ToNumber(args[0]).intValue());
        }
        return thiz.lastIndexOf(ECMA262Impl.ToString(args[0]));
    }

    public String replace(String thiz, Object[] args) {
        if (args.length > 0) {
            Object regexp = args[0];
            String replaceValue = JSObject.getStringArg(args, 1, "undefined");
            JSRegExp exp = JSRegExp.getRegExp(regexp);
            if (exp == null) {
                String s = String.valueOf(regexp);
                int p = thiz.indexOf(s);
                if (p >= 0) {
                    return thiz.substring(0, p) + replaceValue + thiz.substring(p + s.length());
                }
                return thiz;
            }
            Matcher match = exp.pattern.matcher(thiz);
            replaceValue = replaceValue.replaceAll("[\\\\]", "\\\\\\\\").replace("[\\$]{2}", "\\\\$");
            if (exp.globals) {
                return match.replaceAll(replaceValue);
            }
            return match.replaceFirst(replaceValue);
        }
        return thiz;
    }

    public Object match(String thiz, Object[] args) {
        JSRegExp exp = JSRegExp.getRegExp(JSString.getArg(args, 0, null));
        if (exp == null) {
            return null;
        }
        Matcher match = exp.pattern.matcher(thiz);
        if (match.find()) {
            ArrayList<String> result = new ArrayList<String>();
            if (exp.globals) {
                do {
                    result.add(match.group());
                } while (match.find());
            } else {
                int c = match.groupCount();
                for (int i = 0; i <= c; ++i) {
                    result.add(match.group(i));
                }
            }
            return result;
        }
        return null;
    }

    public String slice(String thiz, Object[] args) {
        int end;
        int size = thiz.length();
        int begin = JSArray.toSliceRange(JSObject.getIntArg(args, 0, 0), size);
        if (begin < (end = JSArray.toSliceRange(JSObject.getIntArg(args, 1, size), size))) {
            return thiz.substring(begin, end);
        }
        return "";
    }

    public Object[] split(String thiz, Object[] args) {
        Object separator = JSObject.getArg(args, 0, null);
        if (separator == null) {
            return new String[]{thiz};
        }
        int limit = JSObject.getIntArg(args, 1, -1);
        JSRegExp exp = JSRegExp.getRegExp(separator);
        if (exp != null) {
            Pattern pattern = exp.pattern;
            return exp.pattern.split(thiz, limit);
        }
        Pattern pattern = Pattern.compile(Pattern.quote(String.valueOf(separator)));
        ArrayList<String> rtv = new ArrayList<String>();
        Matcher m = pattern.matcher(thiz);
        int index = 0;
        int ms = 0;
        int me = 0;
        while (m.find()) {
            ms = m.start();
            me = m.end();
            if (limit >= 0 && rtv.size() >= limit || ms == me && index == ms) continue;
            String match = thiz.substring(index, ms);
            rtv.add(match);
            index = me;
        }
        if (!(limit >= 0 && rtv.size() >= limit || ms == me && thiz.length() == ms)) {
            rtv.add(thiz.substring(index));
        }
        return rtv.toArray();
    }

    static int toSubstringRange(int pos, int size) {
        return Math.min(Math.max(pos, 0), size);
    }

    public String substring(String thiz, Object[] args) {
        int size = thiz.length();
        int begin = JSString.toSubstringRange(JSObject.getIntArg(args, 0, 0), size);
        int end = JSString.toSubstringRange(JSObject.getIntArg(args, 1, size), size);
        return thiz.substring(Math.min(begin, end), Math.max(begin, end));
    }

    public String substr(String thiz, Object[] args) {
        int begin;
        int size = thiz.length();
        int len = JSObject.getIntArg(args, 1, size - (begin = JSString.toSubstringRange(JSObject.getIntArg(args, 0, 0), size)));
        if (len > 0) {
            return thiz.substring(begin, Math.min(size, begin + len));
        }
        return "";
    }

    public String toLowerCase(String thiz, Object[] args) {
        return thiz.toLowerCase();
    }

    public String toLocaleLowerCase(String thiz, Object[] args) {
        return thiz.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(String thiz, Object[] args) {
        return thiz.toUpperCase(Locale.getDefault());
    }

    public String toLocaleUpperCase(String thiz, Object[] args) {
        return thiz.toUpperCase(Locale.getDefault());
    }
}

