/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xidea.el.Expression;
import org.xidea.el.ExpressionFactory;
import org.xidea.el.ExpressionInfo;
import org.xidea.el.ExpressionToken;
import org.xidea.el.OperationStrategy;
import org.xidea.el.Reference;
import org.xidea.el.ReferenceExpression;
import org.xidea.el.impl.ExpressionFactoryImpl;
import org.xidea.el.impl.ReferenceImpl;
import org.xidea.el.impl.RefrenceStackImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionImpl
implements Expression,
ReferenceExpression,
ExpressionInfo {
    protected final OperationStrategy strategy;
    protected final ExpressionToken expression;
    protected ExpressionFactory factory;

    public ExpressionImpl(String el) {
        ExpressionFactoryImpl efi = ExpressionFactoryImpl.getInstance();
        this.factory = efi;
        this.expression = (ExpressionToken)efi.parse(el);
        this.strategy = efi.getStrategy();
    }

    public ExpressionImpl(ExpressionToken expression, ExpressionFactory factory, OperationStrategy strategy) {
        this.factory = factory;
        this.strategy = strategy;
        this.expression = expression;
    }

    @Override
    public Object evaluate(Object context) {
        Map<String, Object> contextMap = this.factory.wrapAsContext(context);
        Object result = this.strategy.evaluate(this.expression, contextMap);
        return result;
    }

    @Override
    public Object evaluate(Object ... context) {
        if (context == null || context.length == 0) {
            return this.evaluate((Object)null);
        }
        if (context.length == 1) {
            return this.evaluate(context[0]);
        }
        if ((context.length & 1) == 1) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u662f\u5076\u6570\u4e2a\u6570");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < context.length; ++i) {
            map.put(context[i], context[++i]);
        }
        return this.evaluate((Object)map);
    }

    @Override
    public Reference prepare(Object context) {
        RefrenceStackImpl valueStack = new RefrenceStackImpl(context);
        Object result = this.prepare(this.expression, valueStack);
        if (result instanceof Reference) {
            return (Reference)result;
        }
        return null;
    }

    protected Object prepare(ExpressionToken item, Map<String, Object> vs) {
        Object arg2;
        int type = item.getType();
        if (type == 32) {
            arg2 = item.getParam();
        } else if (type == 96) {
            arg2 = this.strategy.evaluate(item.getRight(), vs);
        } else {
            return this.strategy.evaluate(item, vs);
        }
        Object arg1 = this.prepare(item.getLeft(), vs);
        if (arg1 instanceof Reference) {
            return ((Reference)arg1).next(arg2);
        }
        return new ReferenceImpl(arg1, arg2);
    }

    @Override
    public String toString() {
        return this.expression.toString();
    }

    @Override
    public List<String> getVars() {
        ArrayList<String> list = new ArrayList<String>();
        ExpressionImpl.appendVar(this.expression, list);
        return list;
    }

    private static void appendVar(ExpressionToken el, List<String> list) {
        if (el != null) {
            int type = el.getType();
            if (type > 0) {
                ExpressionImpl.appendVar(el.getRight(), list);
                ExpressionImpl.appendVar(el.getLeft(), list);
            } else if (type == -2) {
                list.add((String)el.getParam());
            }
        }
    }
}

