/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xidea.el.ExpressionSyntaxException;
import org.xidea.el.impl.ParseStatus;
import org.xidea.el.impl.TokenImpl;
import org.xidea.el.json.JSONTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionParser
extends JSONTokenizer {
    private static final TokenImpl TOKEN_TRUE = new TokenImpl(-1, Boolean.TRUE);
    private static final TokenImpl TOKEN_FALSE = new TokenImpl(-1, Boolean.FALSE);
    private static final TokenImpl TOKEN_NULL = new TokenImpl(-1, null);
    private ParseStatus status = ParseStatus.BEGIN;
    private int previousType = Integer.MIN_VALUE;
    private Map<String, Integer> aliasMap = Collections.emptyMap();
    protected ArrayList<TokenImpl> tokens = new ArrayList();
    protected TokenImpl expression;
    private int depth;

    public ExpressionParser(String value) {
        super(value, false);
    }

    public void setAliasMap(Map<String, Integer> aliasMap) {
        this.aliasMap = aliasMap;
    }

    public TokenImpl parseEL() {
        this.skipSpace(0);
        while (this.start < this.end) {
            char c = this.toLower(this.value.charAt(this.start));
            if (c == '\"' || c == '\'') {
                String text = this.findString();
                this.addKeyOrObject(text, false);
            } else if (c >= '0' && c <= '9') {
                Number number = this.findNumber();
                this.addKeyOrObject(number, false);
            } else if (Character.isJavaIdentifierStart(c)) {
                String id = this.findId();
                this.addId(id);
            } else {
                String op = this.findOperator();
                this.addOperator(op);
            }
            this.skipSpace(0);
        }
        if (this.depth != 0) {
            this.fail("\u8868\u8fbe\u5f0f\u62ec\u5f27\u4e0d\u5339\u914d");
        }
        this.prepareSelect();
        LinkedList<TokenImpl> stack = new LinkedList<TokenImpl>();
        try {
            this.toTree(this.right(this.tokens), stack);
        }
        catch (Exception e) {
            this.fail("\u9006\u6ce2\u5170\u5f0f\u6811\u578b\u5316\u5f02\u5e38");
        }
        if (stack.size() != 1) {
            this.fail("\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef");
        }
        this.expression = stack.getFirst();
        this.expression.value = this.value;
        return this.expression;
    }

    private void prepareSelect() {
        int p1 = this.tokens.size();
        while (p1-- > 0) {
            int type1 = this.tokens.get(p1).getType();
            if (type1 == 68) {
                int pos = this.getSelectRange(p1, -1, -1);
                this.tokens.add(pos + 1, new TokenImpl(65534, null));
                ++p1;
                continue;
            }
            if (type1 != 69) continue;
            int end = this.tokens.size();
            int pos = this.getSelectRange(p1, 1, end);
            this.tokens.add(pos, new TokenImpl(65535, null));
        }
    }

    private int getSelectRange(int p2, int inc, int end) {
        int dep = 0;
        while ((p2 += inc) != end) {
            int type2 = this.tokens.get(p2).getType();
            if (type2 <= 0) continue;
            if (type2 == 65534) {
                dep += inc;
            } else if (type2 == 65535) {
                dep -= inc;
            } else if (dep == 0 && this.getPriority(type2) <= this.getPriority(68)) {
                return p2;
            }
            if (dep >= 0) continue;
            return p2;
        }
        return inc > 0 ? end : -1;
    }

    private void toTree(List<TokenImpl> tokens, LinkedList<TokenImpl> stack) {
        block3: for (TokenImpl item : tokens) {
            int type = item.getType();
            switch (type) {
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    stack.addFirst(item);
                    continue block3;
                }
            }
            if ((type & 0xC0) > 0) {
                TokenImpl arg2 = stack.removeFirst();
                TokenImpl arg1 = stack.removeFirst();
                item.setLeft(arg1);
                item.setRight(arg2);
                stack.addFirst(item);
                continue;
            }
            TokenImpl arg1 = stack.removeFirst();
            item.setLeft(arg1);
            stack.addFirst(item);
        }
    }

    private List<TokenImpl> right(List<TokenImpl> tokens) {
        LinkedList<List<TokenImpl>> rightStack = new LinkedList<List<TokenImpl>>();
        rightStack.addFirst(new ArrayList());
        LinkedList<TokenImpl> buffer = new LinkedList<TokenImpl>();
        for (TokenImpl item : tokens) {
            if (item.getType() > 0) {
                TokenImpl operator;
                if (buffer.isEmpty()) {
                    buffer.addFirst(item);
                    continue;
                }
                if (item.getType() == 65534) {
                    buffer.addFirst(item);
                    continue;
                }
                if (item.getType() == 65535) {
                    while ((operator = (TokenImpl)buffer.removeFirst()).getType() != 65534) {
                        this.addRightToken(rightStack, operator);
                    }
                    continue;
                }
                while (!buffer.isEmpty() && this.rightEnd(item, (TokenImpl)buffer.getFirst())) {
                    operator = (TokenImpl)buffer.removeFirst();
                    this.addRightToken(rightStack, operator);
                }
                buffer.addFirst(item);
                continue;
            }
            this.addRightToken(rightStack, item);
        }
        while (!buffer.isEmpty()) {
            TokenImpl operator = (TokenImpl)buffer.removeFirst();
            this.addRightToken(rightStack, operator);
        }
        return (List)rightStack.getFirst();
    }

    private void addRightToken(LinkedList<List<TokenImpl>> rightStack, TokenImpl token) {
        List<TokenImpl> list = rightStack.getFirst();
        list.add(token);
    }

    protected int getPriority(int type) {
        switch (type) {
            case 65534: 
            case 65535: {
                return Integer.MIN_VALUE;
            }
        }
        return (type & 0x3C) << 4 | (type & 0xF00) >> 8;
    }

    private boolean rightEnd(TokenImpl item, TokenImpl privious) {
        int p2;
        int t1 = privious.getType();
        int t2 = item.getType();
        int p1 = this.getPriority(t1);
        if (p1 == (p2 = this.getPriority(t2)) && TokenImpl.isPrefix(t2)) {
            return false;
        }
        return p2 <= p1;
    }

    private void addToken(TokenImpl token) {
        int type = token.getType();
        if (type == 65534 || type < 0) {
            this.replacePrevious();
        }
        if (type == -2) {
            int c;
            Object id = token.getParam();
            Integer op = this.aliasMap.get(id);
            if (op == null && "in".equals(id)) {
                op = 4428;
            }
            if (op != null && ((c = TokenImpl.getArgCount(op)) == 2 && this.status == ParseStatus.EXPRESSION || c == 1 && this.status != ParseStatus.EXPRESSION)) {
                token = new TokenImpl(op, null);
            }
        }
        switch (token.getType()) {
            case 65534: {
                ++this.depth;
                this.status = ParseStatus.BEGIN;
                break;
            }
            case 65535: {
                --this.depth;
                if (this.depth < 0) {
                    this.fail("\u62ec\u5f27\u5f02\u5e38");
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                this.status = ParseStatus.EXPRESSION;
                break;
            }
            default: {
                this.status = ParseStatus.OPERATOR;
            }
        }
        this.previousType = type;
        this.tokens.add(token);
    }

    private void replacePrevious() {
        TokenImpl lt;
        Integer op;
        int last = this.tokens.size() - 1;
        if (this.previousType == -2 && last >= 0 && (op = this.aliasMap.get((lt = this.tokens.get(last)).getParam())) != null) {
            this.tokens.set(last, new TokenImpl(op, null));
            this.status = ParseStatus.OPERATOR;
            this.previousType = op;
        }
    }

    private void addId(String id) {
        if ("true".equals(id)) {
            this.addToken(TOKEN_TRUE);
        } else if ("false".equals(id)) {
            this.addToken(TOKEN_FALSE);
        } else if ("null".equals(id)) {
            this.addToken(TOKEN_NULL);
        } else {
            this.skipSpace(0);
            if (this.previousType == 96) {
                this.addToken(new TokenImpl(-1, id));
            } else {
                this.addKeyOrObject(id, true);
            }
        }
    }

    private String findOperator() {
        int end = this.start + 1;
        char c = this.toLower(this.value.charAt(this.start));
        char next = this.value.length() > end ? this.toLower(this.value.charAt(end)) : (char)'\u0000';
        switch (c) {
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '?': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '}': 
            case '~': {
                break;
            }
            case '=': {
                if (next != '=') {
                    this.fail("\u4e0d\u652f\u6301\u8d4b\u503c\u64cd\u4f5c:");
                }
            }
            case '!': {
                if (next != '=' || this.value.length() <= ++end || this.toLower(this.value.charAt(end)) != '=') break;
                ++end;
                break;
            }
            case '<': 
            case '>': {
                if (next == '=') {
                    ++end;
                    break;
                }
                if (next != c || this.value.length() <= ++end || this.toLower(this.value.charAt(end)) != c) break;
                ++end;
                break;
            }
            case '&': 
            case '|': {
                if (c != next) break;
                ++end;
                break;
            }
            default: {
                return null;
            }
        }
        this.start = end;
        return this.toLower(this.value.substring(this.start, this.start));
    }

    private String toLower(String c) {
        char[] cs = c.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = this.toLower(cs[i]);
        }
        return new String(cs);
    }

    private void fail(String msg) {
        throw new ExpressionSyntaxException(msg + "\n@" + this.start + "\n" + this.value.substring(this.start) + "\n----\n" + this.value);
    }

    private void addOperator(String op) {
        if (op == null) {
            this.fail("\u672a\u77e5\u64cd\u4f5c\u7b26:");
        }
        if (op.length() == 1) {
            switch (op.charAt(0)) {
                case '(': {
                    this.replacePrevious();
                    if (this.status == ParseStatus.EXPRESSION) {
                        this.addToken(new TokenImpl(97, null));
                        if (this.skipSpace(41)) {
                            this.addToken(new TokenImpl(-1, Collections.EMPTY_LIST));
                            ++this.start;
                            break;
                        }
                        this.addList();
                        break;
                    }
                    this.addToken(new TokenImpl(65534, null));
                    break;
                }
                case '[': {
                    if (this.status == ParseStatus.EXPRESSION) {
                        this.addToken(new TokenImpl(96, null));
                        this.addToken(new TokenImpl(65534, null));
                        break;
                    }
                    this.addList();
                    break;
                }
                case '{': {
                    this.addMap();
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    this.addToken(new TokenImpl(65535, null));
                    break;
                }
                case '+': {
                    this.addToken(new TokenImpl(this.status == ParseStatus.EXPRESSION ? 84 : 30, null));
                    break;
                }
                case '-': {
                    this.addToken(new TokenImpl(this.status == ParseStatus.EXPRESSION ? 85 : 31, null));
                    break;
                }
                case ':': {
                    this.addToken(new TokenImpl(69, null));
                    break;
                }
                case ',': {
                    if (this.isMapMethod()) {
                        this.status = ParseStatus.OPERATOR;
                        break;
                    }
                    this.addToken(new TokenImpl(64, null));
                    break;
                }
                case '/': {
                    int end;
                    char next = this.value.charAt(this.start);
                    if (next == '/' || next == '*') {
                        --this.start;
                        this.skipComment();
                        break;
                    }
                    if (this.status != ParseStatus.EXPRESSION && (end = this.findRegExp(this.value, this.start)) > 0) {
                        String regexp = this.value.substring(this.start - 1, end);
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("class", "RegExp");
                        value.put("literal", regexp);
                        this.addToken(new TokenImpl(-1, value));
                        this.start = end;
                        break;
                    }
                    this.addToken(new TokenImpl(op));
                    break;
                }
                default: {
                    this.addToken(new TokenImpl(op));
                    break;
                }
            }
        } else {
            this.addToken(new TokenImpl(op));
        }
    }

    private boolean isMapMethod() {
        int depth = 0;
        for (int i = this.tokens.size() - 1; i >= 0; --i) {
            TokenImpl token = this.tokens.get(i);
            int type = token.getType();
            if (depth == 0) {
                if (type == 65 || type == -4) {
                    return true;
                }
                if (type == 64) {
                    return false;
                }
            }
            if (type == 65534) {
                --depth;
                continue;
            }
            if (type != 65535) continue;
            ++depth;
        }
        return false;
    }

    private void addKeyOrObject(Object object, boolean isVar) {
        if (this.skipSpace(58) && this.isMapMethod()) {
            this.addToken(new TokenImpl(65, object));
            ++this.start;
        } else if (isVar) {
            this.addToken(new TokenImpl(-2, object));
        } else {
            this.addToken(new TokenImpl(-1, object));
        }
    }

    private void addList() {
        this.addToken(new TokenImpl(65534, null));
        this.addToken(new TokenImpl(-3, null));
        if (!this.skipSpace(93)) {
            this.addToken(new TokenImpl(64, null));
        }
    }

    private void addMap() {
        this.addToken(new TokenImpl(65534, null));
        this.addToken(new TokenImpl(-4, null));
    }

    int findRegExp(String text, int start) {
        boolean depth = false;
        int end = text.length();
        while (start < end) {
            char c;
            if ((c = text.charAt(start++)) == '[') {
                depth = true;
                continue;
            }
            if (c == ']') {
                depth = false;
                continue;
            }
            if (c == '\\') {
                ++start;
                continue;
            }
            if (depth || c != '/') continue;
            block4: while (start < end) {
                c = text.charAt(start++);
                switch (c) {
                    case 'g': 
                    case 'i': 
                    case 'm': {
                        continue block4;
                    }
                }
                return start - 1;
            }
        }
        return -1;
    }

    protected boolean skipSpace(int nextChar) {
        char next;
        while (this.start < this.end && Character.isWhitespace(this.value.charAt(this.start))) {
            ++this.start;
        }
        return nextChar > 0 && this.start < this.end && nextChar == (next = this.value.charAt(this.start));
    }
}

