/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xidea.el.ExpressionSyntaxException;
import org.xidea.el.ExpressionToken;
import org.xidea.el.OperationStrategy;
import org.xidea.el.impl.OptimizeStack;
import org.xidea.el.json.JSONEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenImpl
extends AbstractList<Object>
implements ExpressionToken {
    private static final long serialVersionUID = 1L;
    static final int BRACKET_BEGIN = 65534;
    static final int BRACKET_END = 65535;
    static final int OP_GET_STATIC = 32;
    static final int OP_INVOKE_WITH_STATIC_PARAM = 33;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private int type;
    private TokenImpl left;
    private TokenImpl right;
    private Object param;
    String value;
    private static final Map<String, Integer> TOKEN_MAP = new HashMap<String, Integer>();
    private static final Map<Integer, String> LABEL_MAP = new HashMap<Integer, String>();

    public TokenImpl(int type, Object param) {
        this.type = type;
        this.param = param;
    }

    public TokenImpl(String name) {
        if (!TOKEN_MAP.containsKey(name)) {
            throw new ExpressionSyntaxException("\u672a\u77e5\u64cd\u4f5c\u7b26\uff1a" + name);
        }
        this.type = TOKEN_MAP.get(name);
    }

    public TokenImpl optimize(OperationStrategy os, Map<String, Object> context) {
        return this.optimize(os, context, new OptimizeStack(context));
    }

    private TokenImpl optimize(OperationStrategy os, Map<String, Object> context, OptimizeStack vs) {
        if (this.type > 0) {
            int leftType;
            boolean childOptimized = false;
            if (!(this.type != 97 && this.type != 33 || (leftType = this.left.getType()) != 96 && leftType != 32)) {
                this.left.left = this.left.left.optimize(os, context, vs);
                this.left.right = this.left.right.optimize(os, context, vs);
                if (this.right != null) {
                    this.right = this.right.optimize(os, context, vs);
                }
                childOptimized = true;
            }
            try {
                Object o = os.evaluate(this, vs);
                if (o == null || o instanceof Number || o instanceof CharSequence || o instanceof Boolean) {
                    return new TokenImpl(-1, o);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!childOptimized && this.left != null) {
                this.left = this.left.optimize(os, context, vs);
                if (this.right != null) {
                    this.right = this.right.optimize(os, context, vs);
                }
            }
            this.optimize();
        }
        return this;
    }

    private void optimize() {
        if (this.type == 96) {
            if (this.right.getType() == -1) {
                this.type = 32;
                this.setParam(this.right.getParam());
            }
        } else if (this.type == 97) {
            if (this.right.getType() == -3) {
                this.type = 33;
                this.setParam(EMPTY_ARGS);
            } else {
                TokenImpl token = this.right;
                ArrayList<Object> params = null;
                while (token.type == 64) {
                    if (token.right.type == -1) {
                        if (params == null) {
                            params = new ArrayList<Object>();
                        }
                        params.add(0, token.right.getParam());
                        token = token.left;
                        continue;
                    }
                    return;
                }
                if (token.type == -3) {
                    this.type = 33;
                    this.setParam(params.toArray());
                }
            }
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public ExpressionToken getLeft() {
        return this.left;
    }

    @Override
    public ExpressionToken getRight() {
        return this.right;
    }

    @Override
    public Object getParam() {
        return this.param;
    }

    public void setLeft(TokenImpl left) {
        this.left = left;
    }

    public void setRight(TokenImpl right) {
        this.right = right;
    }

    public void setParam(Object param) {
        this.param = param;
    }

    @Override
    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        return LABEL_MAP.get(this.type) + ":" + JSONEncoder.encode(this);
    }

    public static TokenImpl toToken(List<Object> tokens) {
        if (tokens == null) {
            return null;
        }
        int type = ((Number)tokens.get(0)).intValue();
        TokenImpl impl = new TokenImpl(type, null);
        int paramStart = TokenImpl.getArgCount(type) + 1;
        int size = tokens.size();
        switch (Math.min(paramStart, size)) {
            case 3: {
                impl.setRight(TokenImpl.toToken((List)tokens.get(2)));
            }
            case 2: {
                impl.setLeft(TokenImpl.toToken((List)tokens.get(1)));
            }
            case 1: {
                break;
            }
            default: {
                throw new ExpressionSyntaxException("tokens \u9577\u5ea6\u6700\u5927\u70ba4");
            }
        }
        if (paramStart < size) {
            impl.setParam(tokens.get(paramStart));
        }
        return impl;
    }

    @Override
    public Object get(int index) {
        if (this.type == 32) {
            if (index == 0) {
                return 96;
            }
            if (index == 1) {
                return this.left;
            }
            if (index == 2) {
                return this.right;
            }
            return null;
        }
        if (this.type == 33) {
            if (index == 0) {
                return 97;
            }
            if (index == 1) {
                return this.left;
            }
            if (index == 2) {
                return this.right;
            }
            return null;
        }
        if (index == 0) {
            return this.type;
        }
        if (this.type > 0) {
            int paramStart = TokenImpl.getArgCount(this.type) + 1;
            if (index < paramStart) {
                switch (index) {
                    case 1: {
                        return this.left;
                    }
                    case 2: {
                        return this.right;
                    }
                }
            }
            return this.param;
        }
        if (index == 1) {
            return this.param;
        }
        return null;
    }

    @Override
    public int size() {
        if (32 == this.type) {
            return 3;
        }
        if (33 == this.type) {
            return 3;
        }
        int size = TokenImpl.getArgCount(this.type) + 1;
        return this.hasParam() ? size + 1 : size;
    }

    private boolean hasParam() {
        switch (this.type) {
            case -2: 
            case -1: 
            case 32: 
            case 33: 
            case 65: {
                return true;
            }
        }
        return false;
    }

    static int getArgCount(int type) {
        if (type < 0) {
            return 0;
        }
        int c = (type & 0xC0) >> 6;
        return c + 1;
    }

    private static void addToken(int type, String op) {
        TOKEN_MAP.put(op, type);
        LABEL_MAP.put(type, op);
    }

    public static boolean isPrefix(int type) {
        return TokenImpl.getArgCount(type) == 1;
    }

    static {
        TokenImpl.addToken(-1, "value");
        TokenImpl.addToken(-2, "var");
        TokenImpl.addToken(-3, "[]");
        TokenImpl.addToken(-4, "{}");
        TokenImpl.addToken(96, ".");
        TokenImpl.addToken(97, "()");
        TokenImpl.addToken(28, "!");
        TokenImpl.addToken(29, "~");
        TokenImpl.addToken(30, "+");
        TokenImpl.addToken(31, "-");
        TokenImpl.addToken(88, "*");
        TokenImpl.addToken(89, "/");
        TokenImpl.addToken(90, "%");
        TokenImpl.addToken(84, "+");
        TokenImpl.addToken(85, "-");
        TokenImpl.addToken(80, "<<");
        TokenImpl.addToken(81, ">>");
        TokenImpl.addToken(82, ">>>");
        TokenImpl.addToken(332, "<");
        TokenImpl.addToken(333, ">");
        TokenImpl.addToken(334, "<=");
        TokenImpl.addToken(335, ">=");
        TokenImpl.addToken(4428, " in ");
        TokenImpl.addToken(76, "==");
        TokenImpl.addToken(77, "!=");
        TokenImpl.addToken(78, "===");
        TokenImpl.addToken(79, "!==");
        TokenImpl.addToken(1096, "&");
        TokenImpl.addToken(840, "^");
        TokenImpl.addToken(584, "|");
        TokenImpl.addToken(328, "&&");
        TokenImpl.addToken(72, "||");
        TokenImpl.addToken(68, "?");
        TokenImpl.addToken(69, ":");
        TokenImpl.addToken(64, ",");
        TokenImpl.addToken(65, ":");
        TokenImpl.addToken(65534, "(");
        TokenImpl.addToken(65535, ")");
    }
}

