/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.xidea.el.impl.ExpressionFactoryImpl;
import org.xidea.el.impl.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueStackImpl
implements Map<String, Object> {
    protected Object[] stack;

    public ValueStackImpl(Object ... stack) {
        if (stack.length >= 1) {
            this.initialize(stack);
        }
    }

    protected void initialize(Object ... stack) {
        if (stack[0] instanceof ValueStackImpl) {
            Object[] firstStack = ((ValueStackImpl)stack[0]).stack;
            Object[] newStack = new Object[stack.length + firstStack.length - 1];
            if (stack.length > 1) {
                System.arraycopy(firstStack, 0, newStack, 0, firstStack.length);
                System.arraycopy(stack, 1, newStack, firstStack.length, stack.length - 1);
            }
            stack = newStack;
        }
        this.stack = stack;
    }

    @Override
    public Object get(Object key) {
        int i = this.stack.length;
        while (i-- > 0) {
            Object context = this.stack[i];
            if (context instanceof Map) {
                Map contextMap = (Map)context;
                Object result = contextMap.get(key);
                if (result == null && !contextMap.containsKey(key)) continue;
                return result;
            }
            if (context == null) continue;
            Object result = ReflectUtil.getValue(context, key);
            Class<?> clazz = context.getClass();
            if (result != null || ReflectUtil.getPropertyClass(clazz, key) != null) {
                return result;
            }
            if (!(key instanceof String)) continue;
            return ExpressionFactoryImpl.getInvocable(clazz, (String)key, -1);
        }
        return this.fallback(key);
    }

    protected Object fallback(Object key) {
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        this.put(key, value, -1);
        return null;
    }

    public void put(Object key, Object value, int level) {
        if (level < 0) {
            level += this.stack.length;
        }
        ReflectUtil.setValue(this.stack[level], key, value);
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Collection<Object> values() {
        return null;
    }
}

