/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.json;

import java.lang.reflect.Type;
import java.util.List;
import org.xidea.el.json.JSONTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONDecoder {
    private static JSONDecoder decoder = new JSONDecoder(false);
    private static ClassLoader defaultClassLoader = JSONDecoder.class.getClassLoader();
    private JSONTransformer transformer;
    private boolean strict = false;

    public JSONDecoder(boolean strict) {
        this.strict = strict;
        this.transformer = new JSONTransformer();
        this.transformer.setClassLoader(defaultClassLoader);
        if (decoder != null) {
            for (TypeTransformer<? extends Object> le : JSONDecoder.decoder.transformer.objectFactory.values()) {
                this.addTransformer(le);
            }
        }
    }

    public static <T> T decode(String value) {
        return decoder.decodeObject(value, null);
    }

    public void setClassLoader(ClassLoader loader) {
        this.transformer.setClassLoader(loader);
    }

    public static void setDefaultClassLoader(ClassLoader loader) {
        defaultClassLoader = loader;
    }

    public static <T> T decode(String value, Class<?> type) {
        return decoder.decodeObject(value, type);
    }

    public TypeTransformer<? extends Object> addTransformer(TypeTransformer<? extends Object> factory) {
        return this.transformer.addFactory(factory);
    }

    public static TypeTransformer<? extends Object> addDefaultTransformer(TypeTransformer<? extends Object> factory) {
        return JSONDecoder.decoder.transformer.addFactory(factory);
    }

    public <T> T decodeObject(String value, Type type) {
        return this.transformer.decode(value, type, this.strict);
    }

    public <T> List<T> decodeList(String value, Class<T> type) {
        return this.transformer.decodeList(value, type, this.strict);
    }

    public static <T> T transform(Object source, Class<?> type) {
        return (T)JSONDecoder.decoder.transformer.transform(source, type);
    }

    public <T> T transform(Object source, Type type) {
        return (T)this.transformer.transform(source, type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TypeTransformer<T> {
        public boolean externalSetup();

        public T create(Object var1);
    }

    public static @interface Transformer {
    }
}

