/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.json;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.impl.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONEncoder {
    public static final String W3C_DATE_FORMAT = "yyyy-MM-dd";
    public static final String W3C_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mmZ";
    public static final String W3C_DATE_TIME_SECOND_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String W3C_DATE_TIME_MILLISECOND_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static Log log = LogFactory.getLog(JSONEncoder.class);
    private static JSONEncoder encoder = new JSONEncoder("yyyy-MM-dd'T'HH:mm:ss.SSSZ", true, 64);
    private final boolean ignoreClassName;
    private final String dateFormat;
    private final Object[] parent;
    private int index = 0;

    public JSONEncoder(String dateFormat, boolean ignoreClassName, int depth) {
        this.dateFormat = dateFormat;
        this.ignoreClassName = ignoreClassName;
        this.parent = depth > 0 ? new Object[depth] : null;
    }

    public static String encode(Object value) {
        return encoder.encode(value, new StringBuilder()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StringBuilder encode(Object value, StringBuilder out) {
        if (this.parent == null) {
            this.print(value, out);
            return out;
        }
        Object[] objectArray = this.parent;
        synchronized (this.parent) {
            this.index = 0;
            this.print(value, out);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(Object object, StringBuilder out) {
        if (object == null) {
            out.append("null");
            return;
        }
        Class<?> type = object.getClass();
        if (type == Boolean.class) {
            out.append(object.toString());
        } else if (type == String.class) {
            this.printString((String)object, out);
        } else if (type == Character.class) {
            this.printString(object.toString(), out);
        } else if (Number.class.isAssignableFrom(type)) {
            out.append(object.toString());
        } else if (type == Class.class) {
            this.printString(((Class)object).getName(), out);
        } else if (Date.class.isAssignableFrom(type) && this.dateFormat != null) {
            String date = new SimpleDateFormat(this.dateFormat).format((Date)object);
            date = new StringBuilder(date).insert(date.length() - 2, ':').toString();
            this.printString(date, out);
        } else {
            if (this.parent != null) {
                if (this.index > this.parent.length) {
                    this.reportError("\u6df1\u5ea6\u8d85\u51fa\u8bb8\u53ef\u8303\u56f4\uff1a" + out);
                    return;
                }
                if (this.checkNest(object)) {
                    out.append("null");
                    this.reportError("JSON \u6570\u636e\u6e90\u4e2d\u53d1\u73b0\u9012\u5f52\u884c\u4e3a,\u9012\u5f52\u6570\u636e\u5c06\u5f53null\u5904\u7406:" + out);
                    return;
                }
                this.parent[this.index++] = object;
            }
            try {
                if (object instanceof Map) {
                    this.printMap((Map)object, out);
                } else if (type.isArray()) {
                    this.printList(object, out);
                } else if (object instanceof Collection) {
                    this.printList((Collection)object, out);
                } else if (object instanceof Enum) {
                    this.printString(((Enum)object).name(), out);
                } else if (object instanceof URL || object instanceof URI || object instanceof File) {
                    this.printString(object.toString(), out);
                } else {
                    this.printMap(object, out);
                }
            }
            finally {
                if (this.parent != null) {
                    this.parent[--this.index] = null;
                }
            }
        }
    }

    protected void reportError(String error) {
        log.error((Object)error);
    }

    protected boolean checkNest(Object object) {
        int i = this.index;
        if (object instanceof Collection || object instanceof Map || object instanceof Object[]) {
            while (i-- > 0) {
                if (this.parent[i] != object) continue;
                return true;
            }
        } else {
            while (i-- > 0) {
                if (!object.equals(this.parent[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected void printString(String text, StringBuilder out) {
        out.append('\"');
        int len = text.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '/': {
                    if (i > 0 && text.charAt(i - 1) == '<' && text.regionMatches(true, i - 1, "</script", 0, 8)) {
                        out.append('\\');
                    }
                    out.append(c);
                    continue block8;
                }
                case '\"': 
                case '\\': {
                    out.append('\\');
                    out.append(c);
                    continue block8;
                }
                case '\b': {
                    out.append("\\b");
                    continue block8;
                }
                case '\n': {
                    out.append("\\n");
                    continue block8;
                }
                case '\r': {
                    out.append("\\r");
                    continue block8;
                }
                case '\t': {
                    out.append("\\t");
                    continue block8;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        out.append("\\u");
                        out.append(Integer.toHexString(65536 + c), 1, 5);
                        continue block8;
                    }
                    out.append(c);
                }
            }
        }
        out.append('\"');
    }

    protected void printMap(Object object, StringBuilder out) {
        out.append('{');
        try {
            Class<?> clazz = object.getClass();
            Set<String> props = this.getKeySet(clazz);
            Map<String, Method> getterMap = ReflectUtil.getGetterMap(object.getClass());
            Map<String, Field> fieldMap = ReflectUtil.getFieldMap(clazz);
            boolean first = true;
            for (String name : props) {
                try {
                    Object value;
                    Method accessor = getterMap.get(name);
                    if (accessor != null) {
                        value = accessor.invoke(object, new Object[0]);
                    } else {
                        Field field = fieldMap.get(name);
                        if (field == null) continue;
                        value = field.get(object);
                    }
                    if (first) {
                        first = false;
                    } else {
                        out.append(',');
                    }
                    out.append('\"');
                    out.append(name);
                    out.append('\"');
                    out.append(':');
                    this.print(value, out);
                }
                catch (Exception e) {
                    log.warn((Object)"\u5c5e\u6027\u83b7\u53d6\u5931\u8d25", (Throwable)e);
                }
            }
            if (!this.ignoreClassName) {
                if (!first) {
                    out.append(',');
                }
                out.append("\"class\":");
                this.print(object.getClass(), out);
            }
        }
        catch (Exception e) {
            log.warn((Object)"JavaBean\u4fe1\u606f\u83b7\u53d6\u5931\u8d25", (Throwable)e);
        }
        out.append('}');
    }

    protected Set<String> getKeySet(Class<? extends Object> clazz) {
        return ReflectUtil.getPropertySet(clazz);
    }

    protected void printMap(Map<?, ?> map, StringBuilder out) {
        Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
        if (it.hasNext()) {
            out.append('{');
            while (true) {
                Map.Entry<?, ?> e = it.next();
                this.printString(String.valueOf(e.getKey()), out);
                out.append(':');
                this.print(e.getValue(), out);
                if (!it.hasNext()) break;
                out.append(',');
            }
            out.append('}');
        } else {
            out.append("{}");
        }
    }

    protected void printList(Object array, StringBuilder out) {
        out.append('[');
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                out.append(',');
            }
            this.print(Array.get(array, i), out);
        }
        out.append(']');
    }

    protected void printList(Collection<?> list, StringBuilder out) {
        Iterator<?> it = list.iterator();
        if (it.hasNext()) {
            out.append('[');
            while (true) {
                this.print(it.next(), out);
                if (!it.hasNext()) break;
                out.append(',');
            }
            out.append(']');
        } else {
            out.append("[]");
        }
    }
}

