/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.lite;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.json.JSONDecoder;
import org.xidea.lite.LiteCompiler;
import org.xidea.lite.LiteEngine;
import org.xidea.lite.LiteTemplate;
import org.xidea.lite.Template;

public class HotLiteEngine
extends LiteEngine {
    private static final Log log = LogFactory.getLog(HotLiteEngine.class);
    private HashMap<String, Object> lock = new HashMap();
    private HashMap<String, Info> infoMap = new HashMap();
    private LiteCompiler compiler;
    private File cached;
    private File root;

    public HotLiteEngine(File root, File cached) {
        super(cached == null ? null : cached.toURI());
        this.root = root;
        this.cached = cached;
        try {
            this.compiler = new LiteCompiler(root);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Template getTemplate(String path) throws IOException {
        Template template = (Template)this.templateMap.get(path);
        if (template == null || this.isModified(path)) {
            Object lock2 = null;
            Object object = this.lock;
            synchronized (object) {
                lock2 = this.lock.get(path);
                if (lock2 == null) {
                    lock2 = new Object();
                    this.lock.put(path, lock2);
                }
            }
            object = lock2;
            synchronized (object) {
                template = (Template)this.templateMap.get(path);
                if (template == null || this.isModified(path)) {
                    template = this.createTemplate(path);
                    this.templateMap.put(path, template);
                }
            }
            this.lock.remove(path);
            return template;
        }
        return template;
    }

    protected boolean isModified(String path) {
        Info templateEntry = this.infoMap.get(path);
        return templateEntry == null || templateEntry.isModified();
    }

    @Override
    public String getLitecode(String path) {
        throw new IllegalAccessError();
    }

    private void saveCache(String path, String litecode) {
        block3: {
            if (this.cached != null && this.cached.exists()) {
                try {
                    File file = new File(this.cached, path);
                    file.getParentFile().mkdirs();
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                    out.write(litecode);
                    out.close();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("complie result(" + path + ") save failed"), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected Template createTemplate(String path) throws IOException {
        try {
            String litecode = null;
            Info entry = this.infoMap.get(path);
            if (entry == null || entry.isModified()) {
                if (this.cached != null && this.cached.exists() && (litecode = super.getLitecode(path)) != null) {
                    entry = new Info(this.root, litecode);
                    if (entry.isModified()) {
                        litecode = null;
                    } else {
                        this.infoMap.put(path, entry);
                    }
                }
                if (litecode == null && (litecode = this.compiler.compile(path)) != null) {
                    entry = new Info(this.root, litecode);
                    log.info((Object)("\u7f16\u8bd1\u6210\u529f\uff01 \u6587\u4ef6\u5173\u8054\uff1a" + path + ":\t" + Arrays.asList(entry.files)));
                    this.infoMap.put(path, entry);
                    this.saveCache(path, litecode);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Info entry = this.infoMap.get(path);
        return new LiteTemplate(entry.items, entry.config);
    }

    static class Info {
        File[] files;
        long lastModified;
        List<Object> items;
        Map<String, String> config;

        Info(File root, String litecode) {
            long t1 = System.currentTimeMillis();
            List data = (List)JSONDecoder.decode((String)litecode);
            List resources = (List)data.get(0);
            List list = (List)data.get(1);
            Map config = (Map)data.get(2);
            this.items = list;
            this.config = config;
            int len = resources.size();
            this.files = new File[len];
            for (int i = 0; i < len; ++i) {
                this.files[i] = new File(root, ((String)resources.get(i)).substring(1));
            }
            this.lastModified = this.getLastModified(this.files);
            System.out.println(System.currentTimeMillis() - t1);
        }

        Info(List<File> files) {
            this.files = files.toArray(new File[files.size()]);
            this.lastModified = this.getLastModified(this.files);
        }

        boolean isModified() {
            return this.lastModified != this.getLastModified(this.files);
        }

        long getLastModified(File[] files) {
            long i = 0L;
            long j = 0L;
            for (File file : files) {
                long k = file.lastModified();
                if (k == 0L) {
                    ++j;
                }
                j *= 2L;
                i = Math.max(k, i);
            }
            return i + j;
        }
    }
}

