/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.lite;

import java.io.File;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.xidea.el.json.JSONDecoder;
import org.xidea.el.json.JSONEncoder;

public class LiteCompiler {
    private final ScriptEngine engine;
    private File root;

    public LiteCompiler(File root) throws ScriptException {
        this.root = root.getAbsoluteFile();
        this.engine = new ScriptEngineManager().getEngineByExtension("js");
        this.engine.eval(new InputStreamReader(LiteCompiler.class.getResourceAsStream("js-java-proxy.js")));
        this.engine.eval("var root = " + JSONEncoder.encode((Object)this.root.getAbsolutePath()) + ";");
        this.engine.eval("var LiteCompiler = require('lite/src/main/js/compiler').LiteCompiler");
        this.engine.eval("var liteCompiler = new LiteCompiler(root)");
        this.engine.eval("liteCompiler.translator = null;");
    }

    public String compile(String path) throws ScriptException {
        String result = this.engine.eval("JSON.stringify(liteCompiler.compile(" + JSONEncoder.encode((Object)path) + "))").toString();
        Map json = (Map)JSONDecoder.decode((String)result);
        Map config = (Map)json.get("config");
        List resources = (List)json.get("resources");
        List litecode = (List)json.get("litecode");
        return JSONEncoder.encode((Object)new Object[]{resources, litecode, config});
    }

    public void log(Object args) {
        System.out.println(args);
    }
}

