/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.lite;

import java.io.IOException;
import java.util.Map;
import org.xidea.el.Expression;
import org.xidea.lite.RuntimePlugin;
import org.xidea.lite.Template;

public class EncodePlugin
implements RuntimePlugin {
    private Expression el;

    @Override
    public void initialize(Template template, Object[] children) {
        this.el = (Expression)((Object[])children[0])[1];
    }

    @Override
    public void execute(Map<String, Object> context, Appendable out) throws IOException {
        Object value = this.el.evaluate(context);
        if (value instanceof Number && ((Number)value).floatValue() == 0.0f) {
            out.append('0');
            return;
        }
        String text = String.valueOf(value);
        int len = text.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block6;
                }
                case '\"': {
                    out.append("&#34;");
                    continue block6;
                }
                case '\'': {
                    out.append("&#39;");
                    continue block6;
                }
                case '&': {
                    if (this.notEntity(text, i, len)) {
                        out.append("&amp;");
                        continue block6;
                    }
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    private boolean notEntity(String text, int i, int len) {
        int status = 0;
        block8: while (++i < len) {
            char c = text.charAt(i);
            switch (status) {
                case 0: {
                    if (c == '#') {
                        status = 2;
                        break;
                    }
                    if (Character.isJavaIdentifierStart((int)c) && c != '$') {
                        status = 1;
                        break;
                    }
                    return true;
                }
                case 1: {
                    if ((Character.isJavaIdentifierPart((int)c) || c == '$') && c != '.' && c != '-') continue block8;
                    return c != ';';
                }
                case 2: {
                    if (c == 'x') {
                        status = 21;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        status = 20;
                        break;
                    }
                    return true;
                }
                case 20: {
                    if (c >= '0' && c <= '9') break;
                    return c != ';';
                }
                case 21: {
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                        status = 22;
                        break;
                    }
                    return true;
                }
                case 22: {
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue block8;
                    if (c >= 'A' && c <= 'F') break;
                    return c != ';';
                }
                default: {
                    return true;
                }
            }
        }
        return true;
    }
}

