/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.lite;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.impl.ValueStackImpl;
import org.xidea.lite.LiteEngine;

public class FutureWaitStack
extends ValueStackImpl {
    private static final Log log = LogFactory.getLog(LiteEngine.class);
    public static final Class<?> futureClass;
    public static final Method futureGetter;

    public static Map<String, Object> wrap(Map<String, Object> values) {
        return FutureWaitStack.wrap(values, false);
    }

    public static Map<String, Object> wrap(Map<String, Object> values, boolean newTop) {
        if (newTop) {
            return new FutureWaitStack(values, newTop);
        }
        if (futureGetter != null) {
            for (Object v : values.values()) {
                if (!futureClass.isInstance(v)) continue;
                return new FutureWaitStack(values, newTop);
            }
        }
        return values;
    }

    public FutureWaitStack(Object source, boolean newTop) {
        super(new Object[0]);
        if (newTop) {
            this.initialize(new Object[]{source, new HashMap()});
        } else {
            this.initialize(new Object[]{source});
        }
    }

    public Object get(Object key) {
        Object value = super.get(key);
        if (futureGetter != null && futureClass.isInstance(value)) {
            try {
                return futureGetter.invoke(value, new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)e);
                return null;
            }
        }
        return value;
    }

    static {
        Class<?> clazz = null;
        Method getMethod = null;
        try {
            clazz = Class.forName("java.util.concurrent.Future");
            getMethod = clazz.getMethod("get", new Class[0]);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        futureClass = clazz;
        futureGetter = getMethod;
    }
}

