/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.lite;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.json.JSONDecoder;
import org.xidea.lite.LiteTemplate;
import org.xidea.lite.Template;
import org.xidea.lite.TemplateEngine;

public class LiteEngine
implements TemplateEngine {
    private static final Log log = LogFactory.getLog(LiteEngine.class);
    protected URI compiledBase;
    protected Map<String, Template> templateMap = new WeakHashMap<String, Template>();
    protected ExecutorService executorService = Executors.newScheduledThreadPool(8);

    protected LiteEngine() {
    }

    public LiteEngine(URI compiledBase) {
        if (compiledBase != null) {
            this.compiledBase = compiledBase.normalize();
        }
    }

    @Override
    public void render(String path, Object context, Writer out) throws IOException {
        this.getTemplate(path).render(context, out);
        out.flush();
    }

    @Override
    public Template getTemplate(String path) throws IOException {
        Template template = this.templateMap.get(path);
        if (template == null) {
            template = this.createTemplate(path);
            this.templateMap.put(path, template);
            return template;
        }
        return template;
    }

    @Override
    public void clear(String path) {
        this.templateMap.remove(path);
    }

    protected Template createTemplate(String path) throws IOException {
        String litecode = this.getLitecode(path);
        if (litecode != null) {
            List data = (List)JSONDecoder.decode((String)litecode);
            List list = (List)data.get(1);
            Map featureMap = (Map)data.get(2);
            return new LiteTemplate(this.executorService, list, featureMap);
        }
        log.error((Object)("template not found!" + path + '@' + this.compiledBase));
        return null;
    }

    protected String getLitecode(String path) {
        try {
            InputStream in;
            URI uri = this.compiledBase.resolve(this.compiledBase.getPath() + path);
            String scheme = this.compiledBase.getScheme();
            if ("classpath".equals(scheme)) {
                String bp = uri.normalize().getPath();
                in = LiteEngine.class.getResourceAsStream(bp);
            } else {
                if ("file".equals(scheme) && !new File(uri).exists()) {
                    return null;
                }
                in = uri.toURL().openStream();
            }
            if (in != null) {
                return this.loadText(in);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadText(InputStream in) throws IOException {
        try {
            int len;
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            StringBuilder buf = new StringBuilder();
            char[] cbuf = new char[1024];
            while ((len = reader.read(cbuf)) >= 0) {
                buf.append(cbuf, 0, len);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            in.close();
        }
    }
}

