/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.lite;

import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.Expression;
import org.xidea.el.ExpressionFactory;
import org.xidea.el.ExpressionInfo;
import org.xidea.el.fn.ECMA262Impl;
import org.xidea.el.impl.ExpressionFactoryImpl;
import org.xidea.el.impl.ReflectUtil;
import org.xidea.el.json.JSONEncoder;
import org.xidea.lite.DefinePlugin;
import org.xidea.lite.FutureWaitStack;
import org.xidea.lite.ModulePlugin;
import org.xidea.lite.RuntimePlugin;
import org.xidea.lite.Template;

public class LiteTemplate
implements Template {
    private static Log log = LogFactory.getLog(LiteTemplate.class);
    private static final int FOR_TYPE_NO_STATUS = 261;
    private static final int STATIC_BCS_TYPE = -1;
    private static final int FOR_TYPE_FIRST_STATUS = 517;
    private static final int PLUGIN_POS = 2;
    private static final String FOR_KEY = "for";
    private static final String FEATURE_CONTENT_TYPE = "contentType";
    private static final String FEATURE_ENCODING = "encoding";
    protected ExpressionFactory expressionFactory = new ExpressionFactoryImpl();
    protected Object[] items;
    protected Map<String, String> config;
    private transient int modulePlugin = 0;
    private transient int forCount = 0;
    private ExecutorService executorService = Executors.newScheduledThreadPool(10);

    protected LiteTemplate() {
    }

    public LiteTemplate(ExecutorService executorService, List<Object> list, Map<String, String> featureMap) {
        this.executorService = executorService;
        this.config = featureMap;
        this.items = this.compile(list);
        if (this.modulePlugin > 0) {
            Object[] node;
            int lastIndex = this.items.length - 1;
            Object item = this.items[lastIndex];
            if (item instanceof Object[] && ((Number)(node = (Object[])item)[0]).intValue() == -1) {
                item = node[1];
            }
            if (item instanceof String) {
                String last = (String)item;
                String prefix = last.replaceFirst("(?:<\\/body>\\s*)?<\\/html>\\s*$", "");
                String postfix = last.substring(prefix.length());
                this.items[lastIndex] = this.translateText(prefix);
                ArrayList<Object> items = new ArrayList<Object>(Arrays.asList(this.items));
                Object[] cmd = new Object[3];
                cmd[0] = 7;
                cmd[2] = new ModulePlugin.Appender();
                items.add(cmd);
                if (postfix.length() > 0) {
                    items.add(this.translateText(postfix));
                }
                this.items = items.toArray();
            }
        }
    }

    @Override
    public void addVar(String name, Object value) {
        this.expressionFactory.addVar(name, value);
    }

    protected Expression createExpression(Object elo) {
        Expression e = this.expressionFactory.create(elo);
        if (e instanceof ExpressionInfo) {
            if (((ExpressionInfo)e).getVars().contains(FOR_KEY)) {
                ++this.forCount;
            }
        } else {
            ++this.forCount;
        }
        return e;
    }

    protected Object[] compile(List<Object> datas) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        block8: for (Object item : datas) {
            if (item instanceof List) {
                List data = (List)item;
                Object[] cmd = data.toArray();
                int type = ((Number)cmd[0]).intValue();
                cmd[0] = type;
                switch (type) {
                    case 7: {
                        if (!this.compilePlugin(cmd, result)) break;
                        continue block8;
                    }
                    case 5: {
                        cmd[2] = this.createExpression(cmd[2]);
                        int forCount0 = this.forCount;
                        cmd[1] = this.compile((List)cmd[1]);
                        if (this.forCount == forCount0) {
                            cmd[0] = 261;
                        } else if (forCount0 == 0) {
                            cmd[0] = 5;
                        }
                        this.forCount = forCount0;
                        break;
                    }
                    case 3: {
                        if (cmd[2] != null) {
                            cmd[2] = " " + cmd[2] + "=\"";
                        }
                    }
                    case 0: 
                    case 4: 
                    case 8: {
                        cmd[1] = this.createExpression(cmd[1]);
                        break;
                    }
                    case 1: 
                    case 6: {
                        if (cmd[2] != null) {
                            cmd[2] = this.createExpression(cmd[2]);
                        }
                    }
                    case 9: {
                        cmd[1] = this.compile((List)cmd[1]);
                    }
                }
                result.add(cmd);
                continue;
            }
            result.add(this.translateText((String)item));
        }
        return result.toArray();
    }

    private Object[] translateText(String item) {
        String cs = item;
        try {
            return new Object[]{-1, cs, cs.toCharArray(), cs.getBytes(this.getEncoding())};
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean compilePlugin(Object[] cmd, List<Object[]> result) {
        try {
            int forCount0 = this.forCount;
            Map config = (Map)cmd[2];
            Class<?> addonType = Class.forName((String)config.get("class"));
            RuntimePlugin addon = (RuntimePlugin)addonType.newInstance();
            ReflectUtil.setValues((Object)addon, (Map)config);
            Object[] children = this.compile((List)cmd[1]);
            addon.initialize(this, children);
            if (addonType == ModulePlugin.class) {
                ((ModulePlugin)addon).setExecutorService(this.executorService);
                ++this.modulePlugin;
                cmd[2] = addon;
                return false;
            }
            if (addonType == DefinePlugin.class) {
                this.forCount = forCount0;
                return true;
            }
            cmd[2] = addon;
            return false;
        }
        catch (Exception e) {
            log.error((Object)"\u88c5\u8f7d\u6269\u5c55\u5931\u8d25", (Throwable)e);
            return true;
        }
    }

    @Override
    public void render(Object context, Appendable out) throws IOException {
        Map<String, Object> contextMap = FutureWaitStack.wrap(this.expressionFactory.wrapAsContext(context));
        this.render(contextMap, this.items, out);
        if (out instanceof Flushable) {
            ((Flushable)((Object)out)).flush();
        }
    }

    @Override
    public void render(Map<String, Object> context, Object[] children, Appendable out) {
        boolean ifpassed = false;
        for (Object item : children) {
            try {
                Object[] data = (Object[])item;
                switch ((Integer)data[0]) {
                    case -1: {
                        if (out instanceof Writer) {
                            ((Writer)out).write((char[])data[2]);
                            break;
                        }
                        out.append((String)data[1]);
                        break;
                    }
                    case 0: {
                        this.processExpression(context, data, out, false);
                        break;
                    }
                    case 1: {
                        ifpassed = this.processIf(context, data, out);
                        break;
                    }
                    case 6: {
                        if (ifpassed) break;
                        ifpassed = this.processElse(context, data, out);
                        break;
                    }
                    case 5: {
                        ifpassed = this.processFor(context, data, out, 5);
                        break;
                    }
                    case 517: {
                        ifpassed = this.processFor(context, data, out, 517);
                        break;
                    }
                    case 261: {
                        ifpassed = this.processFor(context, data, out, 261);
                        break;
                    }
                    case 4: {
                        this.processExpression(context, data, out, true);
                        break;
                    }
                    case 3: {
                        this.processXA(context, data, out);
                        break;
                    }
                    case 2: {
                        this.prossesBreak(data);
                    }
                    case 7: {
                        this.prossesPlugin(context, data, out);
                        break;
                    }
                    case 8: {
                        this.processVar(context, data);
                        break;
                    }
                    case 9: {
                        this.processCaptrue(context, data);
                    }
                }
            }
            catch (Break e) {
                if (--e.depth <= 0) continue;
                throw e;
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)"\u6a21\u677f\u6e32\u67d3\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void prossesPlugin(Map<String, Object> context, Object[] data, Appendable out) throws Exception {
        try {
            RuntimePlugin addon = (RuntimePlugin)data[2];
            addon.execute(context, out);
        }
        catch (Exception e) {
            System.out.println(JSONEncoder.encode((Object)data));
            e.printStackTrace();
        }
    }

    protected void processExpression(Map<String, Object> context, Object[] data, Appendable out, boolean encodeXML) throws IOException {
        Object value = ((Expression)data[1]).evaluate(context);
        if (encodeXML) {
            this.printXT(ECMA262Impl.ToString((Object)value), out);
        } else {
            out.append(ECMA262Impl.ToString((Object)value));
        }
    }

    protected boolean processIf(Map<String, Object> context, Object[] data, Appendable out) {
        if (this.toBoolean(((Expression)data[2]).evaluate(context))) {
            this.render(context, (Object[])data[1], out);
            return true;
        }
        return false;
    }

    protected boolean processElse(Map<String, Object> context, Object[] data, Appendable out) {
        if (data[2] == null || this.toBoolean(((Expression)data[2]).evaluate(context))) {
            this.render(context, (Object[])data[1], out);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processFor(Map<String, Object> context, Object[] data, Appendable out, int type) {
        Object[] children = (Object[])data[1];
        String varName = (String)data[3];
        ForStatus preiousStatus = type == 5 ? (ForStatus)context.get(FOR_KEY) : null;
        boolean hasElement = false;
        Object[] list = ((Expression)data[2]).evaluate(context);
        try {
            if (list instanceof Map) {
                list = ((Map)list).keySet();
            }
            if (list instanceof Collection) {
                Collection items = (Collection)list;
                boolean bl = hasElement = items.size() > 0;
                if (type == 261) {
                    for (Object item : items) {
                        context.put(varName, item);
                        this.render(context, children, out);
                    }
                } else {
                    ForStatus forStatus = new ForStatus(items.size());
                    context.put(FOR_KEY, forStatus);
                    for (Object item : items) {
                        ++forStatus.index;
                        context.put(varName, item);
                        this.render(context, children, out);
                    }
                }
            } else {
                int i;
                int len;
                if (list instanceof Number) {
                    len = Math.max(((Number)list).intValue(), 0);
                    list = new Object[len];
                    i = 0;
                    while (i < len) {
                        list[i++] = i;
                    }
                } else {
                    len = Array.getLength(list);
                }
                boolean bl = hasElement = len > 0;
                if (type == 261) {
                    for (i = 0; i < len; ++i) {
                        context.put(varName, Array.get(list, i));
                        this.render(context, children, out);
                    }
                } else {
                    ForStatus forStatus = new ForStatus(len);
                    context.put(FOR_KEY, forStatus);
                    while (++forStatus.index < len) {
                        context.put(varName, Array.get(list, forStatus.index));
                        this.render(context, children, out);
                    }
                }
            }
        }
        finally {
            if (type == 5) {
                context.put(FOR_KEY, preiousStatus);
            }
        }
        return hasElement;
    }

    protected void processVar(Map<String, Object> context, Object[] data) {
        context.put((String)data[2], ((Expression)data[1]).evaluate(context));
    }

    protected void processCaptrue(Map<String, Object> context, Object[] data) {
        StringBuilder buf = new StringBuilder();
        this.render(context, (Object[])data[1], buf);
        context.put((String)data[2], buf.toString());
    }

    protected void processXA(Map<String, Object> context, Object[] data, Appendable out) throws IOException {
        Object result = ((Expression)data[1]).evaluate(context);
        if (data[2] == null) {
            this.printXA(ECMA262Impl.ToString((Object)result), out);
        } else if (result != null) {
            out.append((String)data[2]);
            this.printXA(ECMA262Impl.ToString((Object)result), out);
            out.append('\"');
        }
    }

    protected void prossesBreak(Object[] data) {
        throw new Break(((Number)data[1]).intValue());
    }

    protected void printXA(String text, Appendable out) throws IOException {
        int len = text.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block5;
                }
                case '\"': {
                    out.append("&#34;");
                    continue block5;
                }
                case '&': {
                    out.append("&amp;");
                    continue block5;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    protected void printXT(String text, Appendable out) throws IOException {
        int len = text.length();
        block4: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block4;
                }
                case '&': {
                    out.append("&amp;");
                    continue block4;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    protected boolean toBoolean(Object test) {
        if (test == null) {
            return false;
        }
        if (test instanceof Boolean) {
            return (Boolean)test;
        }
        if (test instanceof String) {
            return ((String)test).length() > 0;
        }
        if (test instanceof Number) {
            return ((Number)test).floatValue() != 0.0f;
        }
        return true;
    }

    @Override
    public String getContentType() {
        return this.config.get(FEATURE_CONTENT_TYPE);
    }

    @Override
    public String getEncoding() {
        String encoding = this.config.get(FEATURE_ENCODING);
        return encoding == null ? "utf-8" : encoding;
    }

    static class ForStatus {
        int index = -1;
        int lastIndex;

        ForStatus(int end) {
            this.lastIndex = end - 1;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLastIndex() {
            return this.lastIndex;
        }
    }

    static class Break
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        int depth;

        protected Break(int depth) {
            this.depth = depth;
        }
    }
}

