/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.lite;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.json.JSONEncoder;
import org.xidea.lite.FutureWaitStack;
import org.xidea.lite.RuntimePlugin;
import org.xidea.lite.Template;

public class ModulePlugin
implements RuntimePlugin {
    private static final String MODULE_TASK_KEY = "#MODULE_TASK";
    private static Log log = LogFactory.getLog(ModulePlugin.class);
    private Object[] children;
    private Template template;
    private String id;
    private ExecutorService executorService;

    @Override
    public void initialize(Template template, Object[] children) {
        this.template = template;
        this.children = children;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void execute(final Map<String, Object> context, Appendable out) throws IOException {
        HashMap<String, FutureTask<CharSequence>> moduleResult = (HashMap<String, FutureTask<CharSequence>>)context.get(MODULE_TASK_KEY);
        if (moduleResult == null) {
            moduleResult = new HashMap<String, FutureTask<CharSequence>>();
            context.put(MODULE_TASK_KEY, moduleResult);
        }
        FutureTask<CharSequence> result = new FutureTask<CharSequence>(new Callable<CharSequence>(){

            @Override
            public CharSequence call() {
                StringBuilder buf = new StringBuilder();
                ModulePlugin.this.template.render(FutureWaitStack.wrap(context, true), ModulePlugin.this.children, buf);
                return buf;
            }
        });
        if (this.executorService != null) {
            this.executorService.execute(result);
        } else {
            result.run();
        }
        moduleResult.put(this.id, result);
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    static class Appender
    implements RuntimePlugin {
        Appender() {
        }

        @Override
        public void initialize(Template template, Object[] children) {
        }

        @Override
        public void execute(Map<String, Object> context, Appendable out) throws IOException {
            Map moduleResult = (Map)context.get(ModulePlugin.MODULE_TASK_KEY);
            Map.Entry[] entries = moduleResult.entrySet().toArray(new Map.Entry[moduleResult.size()]);
            boolean waitModule = true;
            while (waitModule) {
                waitModule = false;
                try {
                    Thread.sleep(10L);
                    for (Map.Entry e : entries) {
                        Future value = (Future)e.getValue();
                        if (value.isDone()) {
                            this.widgetArrived(out, (String)e.getKey(), (CharSequence)value.get());
                            continue;
                        }
                        waitModule = true;
                    }
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    log.error((Object)e);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            }
        }

        private void widgetArrived(Appendable out, String id, CharSequence value) throws IOException {
            out.append("<script>__widget_arrived(\"").append(id).append("\",").append(JSONEncoder.encode((Object)value.toString())).append(")</script>");
        }
    }
}

