/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.xipki.util.Args;
import org.xipki.util.ProcessLog;
import org.xipki.util.StringUtil;

public abstract class BenchmarkExecutor {
    public static final String PROPKEY_BENCHMARK = "org.xipki.benchmark";
    private static final int DEFAULT_DURATION = 30;
    private static final int DEFAULT_THREADS = 25;
    private boolean interrupted;
    private final String description;
    private final ProcessLog processLog;
    private int duration = 30;
    private int threads = 25;
    private final AtomicLong errorAccount = new AtomicLong(0L);
    private String unit = "";

    public BenchmarkExecutor(String description) {
        this(description, 0);
    }

    public BenchmarkExecutor(String description, int total) {
        this.description = Args.notNull(description, "description");
        this.processLog = new ProcessLog(total);
    }

    protected abstract Runnable getTestor() throws Exception;

    protected long getRealAccount(long account) {
        return account;
    }

    public void close() {
    }

    public void execute() {
        System.getProperties().setProperty(PROPKEY_BENCHMARK, "true");
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            Runnable runnable;
            try {
                runnable = this.getTestor();
            }
            catch (Exception ex) {
                System.err.println("could not initialize Testor: " + ex.getMessage());
                return;
            }
            runnables.add(runnable);
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotBlank(this.description)) {
            sb.append(this.description);
            char ch = this.description.charAt(this.description.length() - 1);
            if (ch != '\n') {
                sb.append('\n');
            }
        }
        sb.append("threads: ").append(this.threads).append("\n");
        sb.append("duration: ").append(StringUtil.formatTime((long)this.duration, false)).append("\n");
        sb.append("unit: ").append(this.unit);
        System.out.println(sb.toString());
        this.resetStartTime();
        ExecutorService executor = Executors.newFixedThreadPool(this.threads);
        for (Runnable runnable : runnables) {
            executor.execute(runnable);
        }
        executor.shutdown();
        this.printHeader();
        while (true) {
            this.printStatus();
            try {
                boolean terminated = executor.awaitTermination(1L, TimeUnit.SECONDS);
                if (!terminated) continue;
            }
            catch (InterruptedException ex) {
                this.interrupted = true;
                continue;
            }
            break;
        }
        this.printStatus();
        this.printSummary();
        this.close();
        System.getProperties().remove(PROPKEY_BENCHMARK);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public BenchmarkExecutor setDuration(String duration) {
        int num;
        String numStr;
        Args.notBlank(duration, "duration");
        char unit = duration.charAt(duration.length() - 1);
        if (unit == 's' || unit == 'm' || unit == 'h') {
            numStr = duration.substring(0, duration.length() - 1);
        } else {
            unit = 's';
            numStr = duration;
        }
        try {
            num = Integer.parseInt(numStr);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("invalid duration " + duration);
        }
        if (num < 1) {
            throw new IllegalArgumentException("invalid duration " + duration);
        }
        switch (unit) {
            case 's': {
                this.duration = num;
                break;
            }
            case 'm': {
                this.duration = num * 60;
                break;
            }
            case 'h': {
                this.duration = num * 3600;
                break;
            }
            default: {
                throw new IllegalStateException("invalid duration unit " + unit);
            }
        }
        return this;
    }

    public BenchmarkExecutor setThreads(int threads) {
        if (threads > 0) {
            this.threads = threads;
        }
        return this;
    }

    public long getErrorAccout() {
        return this.errorAccount.get();
    }

    public void account(long all, long failed) {
        this.processLog.addNumProcessed(this.getRealAccount(all));
        if (failed != 0L) {
            this.errorAccount.addAndGet(this.getRealAccount(failed));
        }
    }

    public int getThreads() {
        return this.threads;
    }

    protected void resetStartTime() {
        this.processLog.reset();
    }

    protected boolean stop() {
        return this.interrupted || this.errorAccount.get() > 0L || System.currentTimeMillis() - this.processLog.startTimeMs() >= (long)this.duration * 1000L;
    }

    protected void printHeader() {
        this.processLog.printHeader();
    }

    protected void printStatus() {
        this.processLog.printStatus();
    }

    public BenchmarkExecutor setUnit(String unit) {
        this.unit = Args.notNull(unit, "unit");
        return this;
    }

    protected void printSummary() {
        this.processLog.printTrailer();
        String averageText = StringUtil.formatAccount((long)this.processLog.totalAverageSpeed(), 1);
        String msg = StringUtil.concatObjectsCap(400, " started at: ", new Date(this.processLog.startTimeMs()), "\nfinished at: ", new Date(this.processLog.endTimeMs()), "\n   duration: ", StringUtil.formatTime(this.processLog.totalElapsedTime() / 1000L, false), "\n    account: ", StringUtil.formatAccount(this.processLog.numProcessed(), 1), " ", this.unit, "\n     failed: ", StringUtil.formatAccount(this.errorAccount.get(), 1), " ", this.unit, "\n    average: ", averageText, " ", this.unit, "/s\n");
        System.out.println(msg);
    }

    protected static long getSecureIndex() {
        long nextLong;
        SecureRandom random = new SecureRandom();
        while ((nextLong = random.nextLong()) <= 0L) {
        }
        return nextLong;
    }
}

