/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;
import org.xipki.util.StringUtil;

public class ConfPairs {
    private static final char BACKSLASH = '\\';
    public static final char NAME_TERM = '=';
    public static final char TOKEN_TERM = ',';
    private final Map<String, String> pairs = new HashMap<String, String>();

    public ConfPairs() {
    }

    public ConfPairs(String name, String value) {
        this.putPair(name, value);
    }

    public ConfPairs(Map<String, ?> pairs) {
        Iterator<String> iterator = pairs.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            Object value = pairs.get(name = iterator.next());
            this.putPair(name, value == null ? null : value.toString());
        }
    }

    public ConfPairs(String confPairs) {
        if (StringUtil.isBlank(confPairs)) {
            return;
        }
        int len = confPairs.length();
        LinkedList<String> tokens = new LinkedList<String>();
        StringBuilder tokenBuilder = new StringBuilder();
        int i = 0;
        while (i < len) {
            char ch = confPairs.charAt(i);
            if (',' == ch) {
                if (tokenBuilder.length() > 0) {
                    tokens.add(tokenBuilder.toString());
                }
                tokenBuilder = new StringBuilder();
                ++i;
                continue;
            }
            if ('\\' == ch) {
                if (i == len - 1) {
                    throw new IllegalArgumentException("invalid ConfPairs '" + confPairs + "'");
                }
                tokenBuilder.append(ch);
                ch = confPairs.charAt(i + 1);
                ++i;
            }
            tokenBuilder.append(ch);
            ++i;
        }
        if (tokenBuilder.length() > 0) {
            tokens.add(tokenBuilder.toString());
        }
        for (String token : tokens) {
            char ch;
            int termPosition = -1;
            len = token.length();
            int i2 = 0;
            while (i2 < len) {
                ch = token.charAt(i2);
                if (ch == '=') {
                    termPosition = i2;
                    break;
                }
                if ('\\' == ch) {
                    if (i2 == len - 1) {
                        throw new IllegalArgumentException("invalid ConfPairs '" + confPairs + "'");
                    }
                    i2 += 2;
                    continue;
                }
                ++i2;
            }
            if (termPosition < 1) {
                throw new IllegalArgumentException("invalid ConfPair '" + token + "'");
            }
            tokenBuilder = new StringBuilder();
            i2 = 0;
            while (i2 < termPosition) {
                ch = token.charAt(i2);
                if ('\\' == ch) {
                    if (i2 == termPosition - 1) {
                        throw new IllegalArgumentException("invalid ConfPair '" + confPairs + "'");
                    }
                    i2 += 2;
                    continue;
                }
                tokenBuilder.append(ch);
                ++i2;
            }
            String name = tokenBuilder.toString();
            tokenBuilder = new StringBuilder();
            for (int i3 = termPosition + 1; i3 < len; ++i3) {
                char ch2 = token.charAt(i3);
                if ('\\' == ch2) {
                    if (i3 == len - 1) {
                        throw new IllegalArgumentException("invalid ConfPair '" + confPairs + "'");
                    }
                    ch2 = token.charAt(i3 + 1);
                    ++i3;
                }
                tokenBuilder.append(ch2);
            }
            String value = tokenBuilder.toString();
            this.pairs.put(name, value);
        }
    }

    public void putPair(String name, String value) {
        Args.notBlank(name, "name");
        Args.notNull(value, "value");
        char ch = name.charAt(0);
        if (ch >= '0' && ch <= '9') {
            throw new IllegalArgumentException("name begin with " + ch);
        }
        this.pairs.put(name, value);
    }

    public void removePair(String name) {
        Args.notBlank(name, "name");
        this.pairs.remove(name);
    }

    public String value(String name) {
        Args.notBlank(name, "name");
        return this.pairs.get(name);
    }

    public Set<String> names() {
        return Collections.unmodifiableSet(this.pairs.keySet());
    }

    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.pairs);
    }

    public String getEncoded() {
        String value;
        StringBuilder sb = new StringBuilder();
        LinkedList<String> names = new LinkedList<String>();
        for (String name : this.pairs.keySet()) {
            value = this.pairs.get(name);
            if (value.length() > 100) continue;
            names.add(name);
        }
        Collections.sort(names);
        for (String name : this.pairs.keySet()) {
            if (names.contains(name)) continue;
            names.add(name);
        }
        for (String name : names) {
            value = this.pairs.get(name);
            sb.append(ConfPairs.encodeNameOrValue(name));
            sb.append('=');
            if (value != null) {
                sb.append(ConfPairs.encodeNameOrValue(value));
            }
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getEncoded();
    }

    public int hashCode() {
        return this.getEncoded().hashCode();
    }

    public boolean equals(Object obj) {
        Set<String> otherNames;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfPairs)) {
            return false;
        }
        ConfPairs other = (ConfPairs)obj;
        Set<String> thisNames = this.names();
        if (!thisNames.equals(otherNames = other.names())) {
            return false;
        }
        for (String name : thisNames) {
            if (CompareUtil.equalsObject(this.value(name), other.value(name))) continue;
            return false;
        }
        return true;
    }

    private static String encodeNameOrValue(String str) {
        if (str.indexOf(61) == -1 && str.indexOf(44) == -1) {
            return str;
        }
        int n = str.length();
        StringBuilder sb = new StringBuilder(n + 1);
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '=' || ch == ',') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public ConfPairs unmodifiable() {
        return new Unmodifiable(this);
    }

    private static class Unmodifiable
    extends ConfPairs {
        private final ConfPairs underlying;

        private Unmodifiable(ConfPairs underlying) {
            this.underlying = underlying;
        }

        @Override
        public String value(String name) {
            return this.underlying.value(name);
        }

        @Override
        public Set<String> names() {
            return this.underlying.names();
        }

        @Override
        public String getEncoded() {
            return this.underlying.getEncoded();
        }

        @Override
        public String toString() {
            return this.underlying.toString();
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Unmodifiable) {
                return this.underlying.equals(((Unmodifiable)obj).underlying);
            }
            return this.underlying.equals(obj);
        }

        @Override
        public ConfPairs unmodifiable() {
            return this;
        }

        @Override
        public void putPair(String name, String value) {
            throw new UnsupportedOperationException("putPair() is not supported");
        }

        @Override
        public void removePair(String name) {
            throw new UnsupportedOperationException("removePair() is not supported");
        }

        @Override
        public Map<String, String> asMap() {
            return this.underlying.asMap();
        }
    }
}

