/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.ValidatableConf;

public class FileOrValue
extends ValidatableConf {
    private String file;
    private String value;

    public static FileOrValue ofFile(String fileName) {
        FileOrValue ret = new FileOrValue();
        ret.setFile(fileName);
        return ret;
    }

    public static FileOrValue ofValue(String value) {
        FileOrValue ret = new FileOrValue();
        ret.setValue(value);
        return ret;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void validate() throws InvalidConfException {
        this.exactOne(this.file, "file", this.value, "value");
    }

    public String readContent() throws IOException {
        if (this.value != null) {
            return this.value;
        }
        return new String(IoUtil.read(IoUtil.detectPath(this.file)), StandardCharsets.UTF_8);
    }
}

