/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.math.BigInteger;
import org.slf4j.Logger;
import org.xipki.util.Base64;
import org.xipki.util.Hex;

public class LogUtil {
    private LogUtil() {
    }

    public static void error(Logger log, Throwable th) {
        if (!log.isErrorEnabled()) {
            return;
        }
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (traces.length > 2) {
            StackTraceElement trace = traces[2];
            log.error("({} {}), {}: {}", new Object[]{trace.getMethodName(), trace.getLineNumber(), th.getClass().getName(), th.getMessage()});
        } else {
            log.error("{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
        }
        if (th instanceof RuntimeException) {
            log.error("Exception", th);
        } else {
            log.debug("Exception", th);
        }
    }

    public static void error(Logger log, Throwable th, String msg) {
        if (!log.isErrorEnabled()) {
            return;
        }
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (traces.length > 2) {
            StackTraceElement trace = traces[2];
            log.error("({} {}) {}, {}: {}", new Object[]{trace.getMethodName(), trace.getLineNumber(), msg, th.getClass().getName(), th.getMessage()});
        } else {
            log.error("{}, {}: {}", new Object[]{msg, th.getClass().getName(), th.getMessage()});
        }
        if (th instanceof RuntimeException) {
            log.error(msg, th);
        } else {
            log.debug(msg, th);
        }
    }

    public static void warn(Logger log, Throwable th) {
        if (!log.isWarnEnabled()) {
            return;
        }
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (traces.length > 2) {
            StackTraceElement trace = traces[2];
            log.error("({} {}), {}: {}", new Object[]{trace.getMethodName(), trace.getLineNumber(), th.getClass().getName(), th.getMessage()});
        } else {
            log.warn("{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
        }
        if (th instanceof RuntimeException) {
            log.warn("Exception", th);
        } else {
            log.debug("Exception", th);
        }
    }

    public static void warn(Logger log, Throwable th, String msg) {
        if (!log.isWarnEnabled()) {
            return;
        }
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (traces.length > 2) {
            StackTraceElement trace = traces[2];
            log.warn("({} {}) {}, {}: {}", new Object[]{trace.getMethodName(), trace.getLineNumber(), msg, th.getClass().getName(), th.getMessage()});
        } else {
            log.warn("{}, {}: {}", new Object[]{msg, th.getClass().getName(), th.getMessage()});
        }
        if (th instanceof RuntimeException) {
            log.warn(msg, th);
        } else {
            log.debug(msg, th);
        }
    }

    public static String formatCsn(BigInteger serialNumber) {
        return "0x" + Hex.encode(serialNumber.toByteArray());
    }

    public static String base64Encode(byte[] bytes) {
        if (bytes == null) {
            return "NULL";
        }
        if (bytes.length == 0) {
            return "EMPTY";
        }
        return Base64.encodeToString(bytes, true);
    }
}

