/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.SinglePasswordResolver;
import org.xipki.util.Args;

public class PasswordResolverImpl
implements PasswordResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordResolverImpl.class);
    private final ConcurrentLinkedQueue<SinglePasswordResolver> resolvers = new ConcurrentLinkedQueue();
    private boolean initialized = false;
    private String masterPasswordCallback;

    public void init() {
        if (this.initialized) {
            return;
        }
        this.resolvers.add(new SinglePasswordResolver.OBF());
        SinglePasswordResolver.PBE pbe = new SinglePasswordResolver.PBE();
        if (this.masterPasswordCallback != null) {
            pbe.setMasterPasswordCallback(this.masterPasswordCallback);
        }
        this.resolvers.add(pbe);
        this.initialized = true;
    }

    public void registResolver(SinglePasswordResolver resolver) {
        if (resolver == null) {
            LOG.debug("registResolver invoked with null.");
            return;
        }
        boolean replaced = this.resolvers.remove(resolver);
        this.resolvers.add(resolver);
        String txt = replaced ? "replaced" : "added";
        LOG.debug("{} SinglePasswordResolver binding for {}", (Object)txt, (Object)resolver);
    }

    public void unregistResolver(SinglePasswordResolver resolver) {
        if (resolver == null) {
            LOG.debug("unregistResolver invoked with null.");
            return;
        }
        try {
            if (this.resolvers.remove(resolver)) {
                LOG.debug("removed SinglePasswordResolver binding for {}", (Object)resolver);
            } else {
                LOG.debug("no SinglePasswordResolver binding found to remove for '{}'", (Object)resolver);
            }
        }
        catch (Exception ex) {
            LOG.debug("caught Exception({}). service is probably destroyed.", (Object)ex.getMessage());
        }
    }

    @Override
    public char[] resolvePassword(String passwordHint) throws PasswordResolverException {
        Args.notNull((Object)passwordHint, (String)"passwordHint");
        int index = passwordHint.indexOf(58);
        if (index == -1) {
            return passwordHint.toCharArray();
        }
        String protocol = passwordHint.substring(0, index);
        for (SinglePasswordResolver resolver : this.resolvers) {
            if (!resolver.canResolveProtocol(protocol)) continue;
            return resolver.resolvePassword(passwordHint);
        }
        throw new PasswordResolverException("could not find password resolver to resolve password of protocol '" + protocol + "'");
    }

    @Override
    public String protectPassword(String protocol, char[] password) throws PasswordResolverException {
        Args.notNull((Object)protocol, (String)"protocol");
        Args.notNull((Object)password, (String)"password");
        for (SinglePasswordResolver resolver : this.resolvers) {
            if (!resolver.canResolveProtocol(protocol)) continue;
            return resolver.protectPassword(password);
        }
        throw new PasswordResolverException("could not find password resolver to protect password of protocol '" + protocol + "'");
    }

    public void setMasterPasswordCallback(String masterPasswordCallback) {
        this.masterPasswordCallback = masterPasswordCallback;
    }
}

