/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import org.xipki.password.OBFPasswordService;
import org.xipki.password.PBEAlgo;
import org.xipki.password.PBEPasswordService;
import org.xipki.password.PasswordCallback;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public interface SinglePasswordResolver {
    public boolean canResolveProtocol(String var1);

    public char[] resolvePassword(String var1) throws PasswordResolverException;

    public String protectPassword(char[] var1) throws PasswordResolverException;

    public static class PBE
    implements SinglePasswordResolver {
        private char[] masterPassword;
        private final Object masterPasswordLock = new Object();
        private String masterPasswordCallback = "PBE-GUI";
        private PasswordCallback masterPwdCallback;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected char[] getMasterPassword(String encryptedPassword) throws PasswordResolverException {
            Object object = this.masterPasswordLock;
            synchronized (object) {
                this.init();
                if (this.masterPassword == null) {
                    if (this.masterPwdCallback == null) {
                        throw new PasswordResolverException("masterPasswordCallback is not initialized");
                    }
                    this.masterPassword = this.masterPwdCallback.getPassword("Please enter the master password", encryptedPassword);
                }
                return this.masterPassword;
            }
        }

        private void init() {
            PasswordCallback pwdCallback;
            String type;
            if (this.masterPwdCallback != null) {
                return;
            }
            if (StringUtil.isBlank((String)this.masterPasswordCallback)) {
                return;
            }
            String conf = null;
            int delimIndex = this.masterPasswordCallback.indexOf(32);
            if (delimIndex == -1) {
                type = this.masterPasswordCallback.toUpperCase();
            } else {
                type = this.masterPasswordCallback.substring(0, delimIndex).toUpperCase();
                conf = this.masterPasswordCallback.substring(delimIndex + 1);
            }
            switch (type) {
                case "FILE": {
                    pwdCallback = new PasswordCallback.File();
                    break;
                }
                case "GUI": {
                    pwdCallback = new PasswordCallback.Gui();
                    break;
                }
                case "PBE-GUI": {
                    pwdCallback = new PasswordCallback.PBEGui();
                    break;
                }
                case "OBF": {
                    pwdCallback = new PasswordCallback.OBF();
                    if (conf == null || StringUtil.startsWithIgnoreCase((String)conf, (String)"OBF:")) break;
                    conf = StringUtil.concat((String)"OBF:", (String[])new String[]{conf});
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown PasswordCallback type '" + type + "'");
                }
            }
            try {
                pwdCallback.init(conf);
            }
            catch (PasswordResolverException ex) {
                throw new IllegalArgumentException("invalid masterPasswordCallback configuration " + this.masterPasswordCallback + ", " + ex.getClass().getName() + ": " + ex.getMessage());
            }
            this.masterPwdCallback = pwdCallback;
        }

        public void clearMasterPassword() {
            this.masterPassword = null;
        }

        @Override
        public boolean canResolveProtocol(String protocol) {
            return "PBE".equalsIgnoreCase(protocol);
        }

        @Override
        public char[] resolvePassword(String passwordHint) throws PasswordResolverException {
            return PBEPasswordService.decryptPassword(this.getMasterPassword(passwordHint), passwordHint);
        }

        @Override
        public String protectPassword(char[] password) throws PasswordResolverException {
            int iterationCount = 2000;
            return PBEPasswordService.encryptPassword(PBEAlgo.PBEWithHmacSHA256AndAES_256, 2000, this.getMasterPassword(null), password);
        }

        public void setMasterPasswordCallback(String masterPasswordCallback) {
            Args.notBlank((String)masterPasswordCallback, (String)"masterPasswordCallback");
            this.masterPasswordCallback = masterPasswordCallback.trim();
        }
    }

    public static class OBF
    implements SinglePasswordResolver {
        @Override
        public boolean canResolveProtocol(String protocol) {
            return "OBF".equalsIgnoreCase(protocol);
        }

        @Override
        public char[] resolvePassword(String passwordHint) throws PasswordResolverException {
            return OBFPasswordService.deobfuscate(passwordHint).toCharArray();
        }

        @Override
        public String protectPassword(char[] password) throws PasswordResolverException {
            return OBFPasswordService.obfuscate(new String(password));
        }
    }
}

