/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit.extra;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.services.FileMacAuditService;
import org.xipki.audit.services.MacAuditService;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.ConfPairs;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.SqlUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class DatabaseMacAuditService
extends MacAuditService {
    private static final Logger LOG = LoggerFactory.getLogger(FileMacAuditService.class);
    public static final String KEY_DATASOURCE = "datasource";
    private static final String SQL_ADD_AUDIT = SqlUtil.buildInsertSql((String)"AUDIT", (String)"SHARD_ID,ID,TIME,LEVEL,EVENT_TYPE,PREVIOUS_ID,MESSAGE,TAG");
    private static final String SQL_UPDATE_INTEGRITY = "UPDATE INTEGRITY SET TEXT=? WHERE ID=1";
    private int maxMessageLength = 1000;
    private DataSourceWrapper datasource;

    protected void storeIntegrity(String integrityText) {
        PreparedStatement ps = null;
        try {
            ps = this.datasource.prepareStatement(SQL_UPDATE_INTEGRITY);
            ps.setString(1, integrityText);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new IllegalStateException(this.datasource.translate(SQL_UPDATE_INTEGRITY, ex));
        }
        catch (DataAccessException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    protected void doClose() {
        if (this.datasource != null) {
            this.datasource.close();
            this.datasource = null;
        }
    }

    protected void storeLog(Instant date, long thisId, int eventType, String levelText, long previousId, String message, String thisTag) {
        String logMessage = message.length() <= this.maxMessageLength ? message : message.substring(0, this.maxMessageLength - 4) + " ...";
        try {
            PreparedStatement ps = this.datasource.prepareStatement(SQL_ADD_AUDIT);
            try {
                int idx = 1;
                ps.setInt(idx++, this.shardId);
                ps.setLong(idx++, thisId);
                ps.setString(idx++, this.formatDate(date));
                ps.setString(idx++, levelText);
                ps.setInt(idx++, eventType);
                ps.setLong(idx++, previousId);
                ps.setString(idx++, logMessage);
                ps.setString(idx, thisTag);
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                throw this.datasource.translate(SQL_ADD_AUDIT, ex);
            }
            finally {
                this.datasource.releaseResources((Statement)ps, null);
            }
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExtraInit(ConfPairs confPairs) throws InvalidConfException {
        String dataSourceFile = confPairs.value(KEY_DATASOURCE);
        if (StringUtil.isBlank((String)dataSourceFile)) {
            throw new IllegalArgumentException("property datasource not defined");
        }
        Connection conn = null;
        try {
            try (InputStream is = Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)dataSourceFile, (boolean)true), new String[0]), new OpenOption[0]);){
                this.datasource = new DataSourceFactory().createDataSource("audit", is);
            }
            conn = this.datasource.getConnection();
            String str = this.datasource.getFirstStringValue(conn, "DBSCHEMA", "VALUE2", "NAME='MAX_MESSAGE_LEN'");
            this.maxMessageLength = str == null ? 1000 : Integer.parseInt(str);
            long maxId = this.datasource.getMax(conn, "AUDIT", "ID", "SHARD_ID=" + this.shardId);
            if (maxId < 1L) {
                this.id.set(0L);
                this.previousTag = null;
            } else {
                String sql = this.datasource.buildSelectFirstSql(1, "TAG FROM AUDIT WHERE SHARD_ID=" + this.shardId + " AND ID=" + maxId);
                ResultSet rs = null;
                PreparedStatement stmt = null;
                try {
                    stmt = this.datasource.prepareStatement(conn, sql);
                    rs = stmt.executeQuery();
                    rs.next();
                    this.id.set(maxId);
                    this.previousTag = rs.getString("TAG");
                }
                catch (SQLException ex) {
                    try {
                        throw this.datasource.translate(sql, ex);
                    }
                    catch (Throwable throwable) {
                        this.datasource.releaseResources((Statement)stmt, rs, false);
                        throw throwable;
                    }
                }
                this.datasource.releaseResources((Statement)stmt, rs, false);
            }
            String integrityText = this.datasource.getFirstStringValue(conn, "INTEGRITY", "TEXT", "ID=1");
            if (integrityText == null) {
                String sql = "INSERT INTO INTEGRITY (ID,TEXT) VALUES(1,'')";
                try {
                    this.datasource.createStatement(conn).executeUpdate(sql);
                }
                catch (SQLException ex) {
                    throw this.datasource.translate(sql, ex);
                }
            }
            this.verify(this.id.get(), this.previousTag, integrityText, confPairs);
            if (conn == null) return;
        }
        catch (IOException | DataAccessException ex) {
            try {
                throw new IllegalStateException(ex);
            }
            catch (Throwable throwable) {
                if (conn == null) throw throwable;
                this.datasource.returnConnection(conn);
                throw throwable;
            }
        }
        this.datasource.returnConnection(conn);
    }
}

