/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.servlet;

import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ocsp.api.OcspServer;
import org.xipki.ocsp.api.ResponderAndPath;
import org.xipki.util.Args;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

class OcspHealthCheckServlet {
    private static final Logger LOG = LoggerFactory.getLogger(OcspHealthCheckServlet.class);
    private final OcspServer server;

    public OcspHealthCheckServlet(OcspServer server) {
        this.server = (OcspServer)Args.notNull((Object)server, (String)"server");
    }

    public void service(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        String method = req.getMethod();
        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
            resp.setStatus(405);
        }
        this.service0(req).fillResponse(resp);
    }

    private HttpResponse service0(XiHttpRequest req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Access-Control-Allow-Origin", "*");
        try {
            String path = (String)req.getAttribute("xipki_path");
            ResponderAndPath responderAndPath = this.server.getResponderForPath(path);
            if (responderAndPath == null) {
                return new HttpResponse(404, null, headers, null);
            }
            boolean healthy = this.server.healthCheck(responderAndPath.getResponder());
            int status = healthy ? 200 : 500;
            return new HttpResponse(status, null, headers, null);
        }
        catch (Throwable th) {
            LOG.error("Throwable thrown, this should not happen", th);
            return new HttpResponse(500, null, headers, null);
        }
    }
}

