/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.servlet;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.license.api.LicenseFactory;
import org.xipki.ocsp.server.OcspConf;
import org.xipki.ocsp.server.OcspServerImpl;
import org.xipki.ocsp.server.servlet.HttpOcspServlet;
import org.xipki.ocsp.server.servlet.OcspHealthCheckServlet;
import org.xipki.security.Securities;
import org.xipki.util.LogUtil;
import org.xipki.util.ReflectiveUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class OcspHttpFilter
implements XiHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OcspHttpFilter.class);
    private static final String DFLT_CFG = "etc/ocsp/ocsp.json";
    private final Securities securities;
    private final LicenseFactory licenseFactory;
    private final OcspServerImpl server;
    private final OcspHealthCheckServlet healthServlet;
    private final HttpOcspServlet ocspServlet;

    public OcspHttpFilter(String licenseFactoryClazz) throws Exception {
        OcspConf conf;
        XipkiBaseDir.init();
        try {
            conf = OcspConf.readConfFromFile(DFLT_CFG);
        }
        catch (IOException ex) {
            throw new IOException("could not parse configuration file etc/ocsp/ocsp.json", ex);
        }
        catch (InvalidConfException ex) {
            throw new InvalidConfException("could not parse configuration file etc/ocsp/ocsp.json", (Throwable)ex);
        }
        boolean logReqResp = conf.isLogReqResp();
        LOG.info("logReqResp: {}", (Object)logReqResp);
        this.securities = new Securities();
        this.securities.init(conf.getSecurity());
        LOG.info("Use licenseFactory: {}", (Object)licenseFactoryClazz);
        this.licenseFactory = (LicenseFactory)ReflectiveUtil.newInstance((String)licenseFactoryClazz);
        OcspServerImpl ocspServer = new OcspServerImpl(this.licenseFactory.createOcspLicense());
        ocspServer.setSecurityFactory(this.securities.getSecurityFactory());
        ocspServer.setConfFile(conf.getServerConf());
        try {
            ocspServer.init(true);
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not start OCSP server");
        }
        this.server = ocspServer;
        this.healthServlet = new OcspHealthCheckServlet(this.server);
        this.ocspServlet = new HttpOcspServlet(logReqResp, this.server);
    }

    public void destroy() {
        if (this.securities != null) {
            this.securities.close();
        }
        if (this.server != null) {
            this.server.close();
        }
        if (this.licenseFactory != null) {
            this.licenseFactory.close();
        }
    }

    public void doFilter(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        String requestUri = req.getRequestURI();
        String contextPath = req.getContextPath();
        String path = requestUri.length() == contextPath.length() ? "/" : requestUri.substring(contextPath.length());
        if (path.startsWith("/health/")) {
            String servletPath = path.substring(7);
            req.setAttribute("xipki_path", servletPath);
            this.healthServlet.service(req, resp);
        } else {
            req.setAttribute("xipki_path", path);
            this.ocspServlet.service(req, resp);
        }
    }
}

